Review

# Analytical Methods Used in Determining Antioxidant Activity: A Review

Irina Georgiana Munteanu and Constantin Apetrei \*

Citation: Munteanu, I.G.; Apetrei, C. Analytical Methods Used in Determining Antioxidant Activity: A Review. Int. J. Mol. Sci. 2021, 22, 3380. https://doi.org/10.3390/ijms22073380

Academic Editor: Dimitra Hadjipavlou‐Litina

Received: 23 February 2021   
Accepted: 22 March 2021   
Published: 25 March 2021

Publisher’s Note: MDPI stays neu‐ tral with regard to jurisdictional claims in published maps and insti‐ tutional affiliations.

Department of Chemistry, Physics and Environment, Faculty of Sciences and Environment, “Dunărea de Jos” University of Galaţi, 47 Domneasca Street, 800008 Galaţi, Romania; georgiana.munteanu@ugal.ro   
\* Correspondence: apetreic@ugal.ro; Tel.: +40‐727‐580‐914

Abstract: The study of antioxidants and their implications in various fields, from food engineering to medicine and pharmacy, is of major interest to the scientific community. The present paper is a critical presentation of the most important tests used to determine the antioxidant activity, detection mechanism, applicability, advantages and disadvantages of these methods. Out of the tests based on the transfer of a hydrogen atom, the following were presented: the Oxygen Radical Absorption Capacity (ORAC) test, the Hydroxyl Radical Antioxidant Capacity (HORAC) test, the Total Peroxyl Radical Trapping Antioxidant Parameter (TRAP) test, and the Total Oxyradical Scavenging Capac‐ ity (TOSC) test. The tests based on the transfer of one electron include the Cupric Reducing Antiox‐ idant Power (CUPRAC) test, the Ferric Reducing Antioxidant Power (FRAP) test, the Folin–Ciocal‐ teu test. Mixed tests, including the transfer of both a hydrogen atom and an electron, include the $2 , 2 ^ { \prime } .$ ‐Azinobis‐(3‐ethylbenzothiazoline‐6‐sulfonic acid (ABTS) test, and the [2,2‐di(4‐tert‐oc‐ tylphenyl)‐1 ‐picrylhydrazyl] (DPPH) test. All these assays are based on chemical reactions and as‐ sessing the kinetics or reaching the equilibrium state relies on spectrophotometry, presupposing the occurrence of characteristic colours or the discolouration of the solutions to be analysed, which are processes monitored by specific wavelength adsorption. These assays were successfully applied in antioxidant analysis or the determination of the antioxidant capacity of complex samples. As a com‐ plementary method in such studies, one may use methods based on electrochemical (bio)sensors, requiring stages of calibration and validation. The use of chemical methods together with electro‐ chemical methods may result in clarification of the operating mechanisms and kinetics of the pro‐ cesses involving several antioxidants.

Keywords: antioxidant activity; superoxyde dismutase (SOD); reactive oxygen species (ROS)

# 1. Introduction

The occurrence of degenerative processes is correlated in molecular biology with the existence of a surplus of free radicals, promoting oxidative processes that are harmful to the body. Plants’ high content of compounds with antioxidant properties able to capture free radicals (carotenoidic, phenolic, flavonic, anthocyanic derivatives, unsaturated fatty acids, vitamins, enzymes and cofactors) has stimulated interest in using them in prophy‐ lactic and curative phytotherapy.

The role of the antioxidants is to neutralise the free radicals in biological cells, the free radicals having a negative impact on living organisms. A special role in neutralising the effects of the oxidative stress related to the presence of free radicals is played by the enzyme called superoxyde dismutase (SOD). It is a metaloenzyme with subunitary struc‐ tural organisation, being the main regulator of the oxidation processes in biological cells. This enzyme catalyses the recombination reaction of the oxygen radicals. Applying anti‐ oxidant therapy by using SOD is efficient in treating various pathological states of the human body, as well as in preventing their occurrence (it prevents the formation of hy‐ drogen peroxyde and triplet oxygen).

Oxidative stress is a relatively new concept, widely used in medical sciences in the past three decades. It takes an active part in the physiology of very common diseases, like diabetes, high blood pressure, preeclampsia, atherosclerosis, acute renal failure, Alz‐ heimer’s and Parkinson’s. The cells, through metabolising oxygen, create reactive species of oxygen (ROS), that are potentially harmful. Under normal circumstances, the rate and amplitude of oxidant formation is balanced by the rate of their removal. However, loss of balance between pro‐oxidants and antioxidants results in oxidative stress. High levels of ROS in biological cells have a large impact on their functioning, leading to deficient cell operation, aging, or disease [1].

The presumed ROS and non free‐radical species are summarised in Table 1.

Table 1. Reactive oxygen species (ROS) and non free‐radical species.   

<html><body><table><tr><td>Reactive Oxygen Species</td><td colspan="3">Non Free-Radical Species</td></tr><tr><td>Hydroxyl radical</td><td>HO·</td><td>Hydrogen peroxide</td><td>HO2</td></tr><tr><td>Superoxide radical</td><td>O·</td><td>Singlet oxygen</td><td>102</td></tr><tr><td>Hydroperoxyl radical</td><td>HOO·</td><td>Ozone</td><td>O3</td></tr><tr><td>Lipid radical</td><td>L·</td><td>Lipid hydroperoxide</td><td>LOOH</td></tr><tr><td>Lipid peroxyl radical</td><td>LOO·</td><td>Hypochlorous acid</td><td>HOCl</td></tr><tr><td>Peroxyl radical</td><td>ROO·</td><td>Peroxynitrite</td><td>ONOO-</td></tr><tr><td>Lipid alkoxyl radical</td><td>LO·</td><td>Dinitrogen trioxide</td><td>N2O3</td></tr><tr><td>Nitrogen dioxide radical</td><td>NO2·</td><td>Nitrous acid</td><td>HNO2</td></tr><tr><td>Nitric oxide radical</td><td>NO·</td><td>Nitryl chloride</td><td>NO2C1</td></tr><tr><td>Thiyl radical</td><td>RS·</td><td>Nitroxyl anion</td><td>NO-</td></tr><tr><td>Protein radical</td><td>P·</td><td>Nitrosyl cation</td><td>NO+</td></tr></table></body></html>

Numerous studies show that antioxidants play an essential role in maintaining hu‐ man health, preventing and treating diseases, due to their ability to reduce oxidative stress. Measuring the antioxidant activity/capacity of foods and biological samples is therefore essential not only in ensuring the quality of functional foods, but more im‐ portantly in studying the efficiency of food antioxidants in preventing and treating the diseases related to oxidative stress.

Antioxidants are compounds which, when present in foods or the human body in very low concentrations, delay, control or prevent oxidative processes leading to food quality deterioration or the occurrence and propagation of degenerative diseases in the organism. A number of methods and activities are involved in the process of inhibiting the oxidation by these antioxidant compounds [2].

Molecules with antioxidant properties may be produced endogenously or ingested exogenously by diet or food supplements. The main endogenous antioxidant enzymes are SOD, catalase (CAT), and glutathion peroxydase (GSH $\mathrm { { . P x } }$ ). SOD converts the superoxide anion to $\mathrm { H } _ { 2 } \mathrm { O } _ { 2 } ,$ which is a substrate for CAT and GSH‐Px. Catalase metabolises $\mathrm { H } _ { 2 } \mathrm { O } _ { 2 }$ in water and oxygen, and GSH‐ $\mathrm { . P x }$ reduces both $\mathrm { H } _ { 2 } \mathrm { O } _ { 2 } ,$ and organic hydroperoxydes when reacting with glutathion (GSH).

Exogenous antioxidants, like vitamins E and $C ,$ may exist in the organism in the cell membrane, and the intracellular and extracellular liquid. They react with ROS to eliminate or to inhibit them. The hydrophobic lipid interior of the membranes requires a different spectrum of antioxidants. Fat‐soluble vitamin E is the most important antioxidant in this environment, protecting against loss of membrane integrity.

Fat‐soluble antioxidants are important in preventing the peroxidation of polyunsatu‐ rated fatty acids (PUFA) in biological membranes. Water‐soluble antioxidants, like vita‐ min C, play a key role in neutralising ROS in the hydrophilic phase.

This review provides a general and up‐to‐date overview of methods available for measuring antioxidant activity and the chemistry principle behind them. In addition, the most important advantages and shortcomings of each method were analysed and high‐ lighted. Understanding the principle mechanisms, advantages and limitations of the measurement assays is important for proper selection of method(s) for valid evaluation of antioxidant potential in practical applications.

# 2. Classification of Antioxidants

According to their operating mechanism, antioxidants may be classified into primary and secondary antioxidants. The antioxidants inhibit the chain reaction of oxidation, act‐ ing as hydrogen donors or acceptors of free radicals, generating stabler radicals. The an‐ tioxidants in this group mainly have a phenolic structure and include the following: anti‐ oxidant minerals, antioxidant vitamins and phytochemicals, among which there are fla‐ vonoids, catechins, carotenoids, $\beta \cdot$ ‐carotene, lycopene, diterpene and their derivatives. These compounds interact by a variety of mechanisms including binding of metal ions, scavenging reactive oxygen species, converting hydroperoxides to non‐radical species, absorbing UV radiation or deactivating singlet oxygen. This category includes: butylhy‐ droxyanisol (BHA), butylhydroxytoluene (BHT) and propyl galate (PG) [3].

The efficacy of antioxidant compounds depends on several factors, the most im‐ portant being structural properties, temperature, the characteristics of the substrate sus‐ ceptible to oxidisation, concentration, along with the presence of synergistic and pro‐oxi‐ dant compounds and the physical state of the system. The chemical structure of an anti‐ oxidant determines its intrinsic reactivity to free radicals and other ROS and thus influ‐ ences antioxidant activity. The efficiency of antioxidants also depends on their concentra‐ tion and localisation in the system, e.g., the interface distribution [4]. Another factor with an important role in their protective action, in the short or long‐term, is the kinetics of the reaction. This involves the reaction rate between an antioxidant and a distinct oxidant, the thermodynamics of the reaction and the antioxidant’s ability to react [5]. All these param‐ eters should be taken into account when considering the efficiency and selection of an antioxidant substance suitable for a particular use.

Figure 1 illustrates the classification of antioxidants whereas Figure 2 indicates the application scope of antioxidants.

![](images/4d8f3c56f0be917c946298331ee49a1ec85424f5cdce69a3776e5f94694cff29.jpg)  
Figure 1. Classification of antioxidants [6].

![](images/1de9e69c9b60f2af48576a198cd00eeca4abe1db862aa89147e7a7e681b84f2a.jpg)  
Figure 2. Application scope of antioxidants [7].

# 3. Measuring the Antioxidant Activity

The methods and instruments used to measure the activity of the antioxidants have made remarkable progress in the past few decades. Early methods measure the efficiency of the antioxidants against the formation of particular species of oxidation products and thus, are based on measuring lipid oxidation. Thus far, various chemical tests coupled with highly sensitive and automated detection technologies have been used to evaluate antioxidant activity by special methods, like for instance scavenging activity against dif‐ ferent types of free radicals or ROS, reducing power and metal chelation, among others. Oxidation substrates have also been extended from food model systems to chemical com‐ pounds, biological materials, cellular lines and even living tissues [2].

A high number of tests are available for the direct measurement of the transfer of the hydrogen atom or the transfer of electrons from antioxidants to free radicals. The antiox‐ idant activities reported in this method group are generally associated with their capacity to neutralise certain types of radical species, out of which some may be artificial and bio‐ logically irrelevant. As a result, these methods have the disadvantage that they do not reflect the situation in an oxidant food or an in vivo case. Nevertheless, the data regarding the hydrogen atom transfer or the data regarding the donating capacity of the electrons obtained by these methods provide important information on their intrinsic antioxidant potential with minimal environment interference. These tests do not require a lipid sub‐ strate and normally use a chemical system containing an oxidant (free radicals or other ROS), an oxidising substrate (some tests do not need it) and antioxidants under investiga‐ tion.

A standardised method for antioxidant activity of a food component should meet the following ideal requirements [8]:

 The radical source used must be biologically relevant;   
 It is desirable for it to be simple;   
 The method used must have a defined endpoint and chemical mechanism;   
 Both the instruments used and the chemicals must be readily available;   
 Reproducibility within the cycle and between days is appropriate;   
 It allows analysis for both hydrophilic and lipophilic antioxidants, using different radical sources;   
 The method must be applicable for quality control analyses.

It should be emphasised that antioxidant activity must not be tested on the basis of a single method. Several antioxidant procedures should be performed in vitro to determine antioxidant activities for the sample of interest. Taking this into account, it is difficult to compare one method completely with another. Therefore, the methods of analysis must be checked before choosing one for the purpose of research.

The various methods for evaluation of the antioxidant capacity fall into three distinct categories namely, spectrometry, electrochemical assays and chromatography [3] as presented in Table 2.

Table 2. Different techniques used to measure antioxidant activity.   

<html><body><table><tr><td></td><td>Techniques Antioxidant Capacty</td><td>Principle of the Method</td><td>End-product Determination</td></tr><tr><td rowspan="5"></td><td>ORAC</td><td>Antioxidant reaction with peroxyl radicals, induced by 2,2&#x27;-azobis-2-amidino-propane Loss of fluorescence of fluorescein (AAPH)</td><td></td></tr><tr><td>HORAC</td><td>Antioxidant capacity to quench OH radicals generated by a Co(II) based Fenton-like system</td><td>Loss of fluorescence of fluorescein</td></tr><tr><td>TRAP</td><td>Antioxidant capacity to scavenge luminol- deridcs</td><td></td></tr><tr><td>CUPRAC</td><td>Cu (II) reduction to Cu (I) by antioxidants Colorimetry</td><td></td></tr><tr><td>FRAP</td><td>Antioxidant reaction with a Fe(III) complex</td><td>Colorimetry</td></tr></table></body></html>

<html><body><table><tr><td rowspan="5"></td><td>PFRAP</td><td>Potassium ferricyanide reduction by antioxidants and subsequent reaction ofColorimetry potassium ferrocyanide with Fe3+</td><td></td></tr><tr><td>ABTS</td><td>Antioxidant reaction with an organic cation radical</td><td>Colorimetry</td></tr><tr><td>DPPH</td><td>Antioxidant reaction with an organic radical</td><td>Colorimetry</td></tr><tr><td>Fluorimetric Analysis</td><td>Emission of light by a compound, which heactroie wavelength</td><td>Rectadinef lsionscece</td></tr><tr><td>Voltammetry</td><td>The reduction or oxidation of a compound at the surface of a working electrode, at the appropriate applied potential, resulting in Measurement of the current of the the mass transport of new material to the electrode surface and in the generation of a</td><td>cathodic/anodic peak</td></tr><tr><td rowspan="3"></td><td>Amperometry</td><td>current The potential of the working electrode is set at a fixed value with respect</td><td>Measurement of the current generated by the oxidation/</td></tr><tr><td>Biamperometry</td><td>to a reference electrode The reaction of the analyte (antioxidant) with the oxidised form of a reversible</td><td>reduction of an electroactive analyte Measurement of the current flowing between two identical working electrodes, at a small potential</td></tr><tr><td></td><td>indicating redox couple</td><td>difference and immersed in a solution containing the analysed sample and a reversible redox couple</td></tr><tr><td rowspan="2"></td><td>Gas</td><td>Separation of the compounds in a mixture Flame ionisation or thermal is based on the repartition between a liquid conductivity chromatographystatioapaseandgmobilee</td><td>detection</td></tr><tr><td>Perfhormance liquid</td><td>iSebaeonesi stationary phase and a liquid mobile phase chroatapia</td><td>spectrometry or electrochemical detection</td></tr></table></body></html>

ORAC‐ Oxygen Radical Absorption Capacity; HORAC—Hydroxyl Radical Antioxidant Capacity; TRAP ‐ Total Peroxyl Radical Trapping Antioxidant Parameter; CUPRAC—Cupric Reducing Antioxidant Power; FRAP ‐ Ferric Reducing Anti‐ oxidant Power; PFRAP ‐ potassium ferricyanide reducing power; ABTS ‐ 2,2′‐Azinobis‐(3‐ethylbenzothiazoline‐6‐sulfonic acid; DPPH—[2,2‐di(4‐tert‐octylphenyl)‐1 ‐picrylhydrazyl].

# 4. Chemical Tests Determining Antioxidant Activity

According to the chemical reactions that may be involved, these tests are divided into two categories: hydrogen atom transfer (HAT) and single electron transfer (SET) reaction‐ based methods. The end result is the same, regardless of the reaction mechanism involved, although the kinetics and reaction stages are different [8]. The SET and HAT reactions coupled with proton exchange reactions may occur in parallel with the main reactions, and in this case the dominant mechanism in a given system depends on the antioxidant structure and properties, solubility and partition coefficient, as well as the solvent system.

The chemical tests measuring antioxidant capacity are accessible, fast, and typically automated, being used predominantly in screening and initial assessment of new antiox‐ idant compounds or the extracts of final real products/by‐products.

# 4.1. Tests Based on the Transfer of the Hydrogen Atom (HAT)

The tests based on the transfer of the hydrogen atom measure the ability of an antioxi‐ dant to remove the free radicals by donating a hydrogen atom. The HAT mechanisms of antioxidant action are proven in the following reaction where the hydrogen atom (H) of a phenol (ArOH) is transferred to a peroxyl radical:

$$
\mathrm { R O O ^ { \bullet } + A H / A r O H \bullet \mathrm { R O O H } + A ^ { \bullet } / A r O ^ { \bullet } }
$$

where: the aryloxyl radical $( \mathrm { A r O } \bullet )$ formed from the reaction of the phenol $( \mathrm { A r O H } ,$ an antioxidant) with a peroxyl radical (ROO•) is stabilised by resonance and AH are the pro‐ tected biomolecules.

An efficient phenolic antioxidant should react faster than the biomolecules (the pro‐ tected molecule) with the free radicals in order to give a protective effect against their oxidation [9].

Typical examples of HAT‐based tests are the Oxygen Radical Absorption Capacity (ORAC), Total Peroxyl Radical Trapping Antioxidant Parameter (TRAP) and Total $\mathrm { O x } .$ ‐ yradical Scavenging Capacity (TOSC) assays [10].

# 4.1.1. The ORAC Test

The ORAC test measures the splitting ability of the radical chain reaction by antioxi‐ dants through monitoring the inhibition of the oxidation of the peroxyl radical. Peroxyl radicals are characterised as free radicals that predominate in lipid oxidation in biological systems and also in foodstuffs, under physiological conditions. As a result, ORAC values are appreciated by certain researchers as biologically relevant, a benchmark for antioxi‐ dant efficiency.

Commonly used peroxyl radical generators in this assay are represented by azo‐com‐ pounds, including lipophilic $\alpha , \alpha ,$ ‐azobisizobutyronytril (AIBN), 2,2‐azobis(2‐amidi‐ nopropane) chlorhydrate (ABAP), $2 , 2 ^ { \prime } .$ ‐azobis(2,4‐dimethylvaleronytril) (AMVN) and the hydrophilic $2 , 2 ^ { \prime } .$ ‐azobis(2‐amidinopropane) dihydrochloride (AAPH) [11].

According to this test, the peroxyl radical emitted by a generator reacts with a fluo‐ rescent sample that leads to loss of fluorescence, registered on a fluorimeter. This method uses the area‐under‐curve technique in the presence and in absence of the antioxidant. As a reference compound is used a standard antioxidant, typically trolox, and the ORAC val‐ ues of the evaluated antioxidants are described as trolox equivalent. The ORAC test de‐ scribes the antioxidants’ ability to yield the hydrogen atom and, consequently, it is a HAT‐ based assay. In order to improve the method, a high‐throughput assay has been devel‐ oped using a multichannel liquid handling system coupled with a microplate fluorescence reader [12].

The system $_ { \mathrm { H _ { 2 } O _ { 2 } - C u S O _ { 4 } } }$ is generally used as a hydroxyl radical generator and $\beta$ ‐ phycoerythrin used as a redox‐sensitive fluorescent indicator protein, whose decay in flu‐ orescence is measured in the presence of free radical scavengers, using Trolox as standard (Figure 3). In the first step, complexation of $\operatorname { C u } ( \operatorname { I I } )$ by $\mathrm { H } _ { 2 } \mathrm { O } _ { 2 }$ leads to the formation of cop‐ per(II) hydroperoxide. The latter suffers unimolecular decomposition in the slow step to form $\mathrm { { C u ( I ) } }$ and $\mathrm { O } _ { 2 } \mathrm { - }$ . In the absence of hydrogen‐atom donors, the homolytic cleavage of the ${ \mathrm { C u } } { - } \mathrm { O }$ bond might be the preferred pathway for the decomposition of $\mathrm { C u O O H ^ { + } }$ . In the next equation, $\mathrm { { C u ( I ) } }$ reacts with $\mathrm { H } _ { 2 } \mathrm { O } _ { 2 }$ to form a hydroxyl free radical.

The azo AAPH compound is the most used peroxyl radical generator in hydrophilic systems, using as fluorescent probe $\beta$ ‐phycoerythrin or, more recently, fluorescein. Thus, peroxyl radicals are formed by thermodecomposition of AAPH, giving an alkyl radical that reacts with molecular oxygen to give peroxyl radical. Taking into account the fact that the generation of peroxyl radical is influenced by temperature, it is considered one of the major factors that interfere with the results. Small temperature differences in the external wells of the microplate can decrease the reproducibility of the assay. Thus, it is of major importance to monitor and adjust the temperature during the assay. Nevertheless, the problem was remedied by developing automated fluorescent microplate readers pro‐ vided with an incubator [8].

A series of fluorescent materials were described and proposed as samples in the ORAC test. Initially, the protein isolated from Porphyridium cruentum, $\beta$ ‐phycoerythrin, was used as the fluorescent probe, which reacts with ROO∙  to form a non‐fluorescent product. However, the use of $\beta$ ‐phycoerythrin in antioxidant assays has shortcomings for some reasons:

$\beta \cdot$ ‐phycoerythrin has large variability in reactivity to ROO∙, leading to inconsistency in assay results;   
$\beta$ ‐phycoerythrin becomes photobleached after exposure to excitation light interaction with polyphenols by nonspecific protein binding [12].

Alternative synthetic protein‐devoid samples were identified as $\beta$ ‐phycoerythrin re‐ placements, among which fluorescein is the fluorescent sample most commonly used for the ORAC test in recent decades. Though, it was shown that fluorescein undergoes unde‐ sired fluorescence loss and secondary reactions [13], and new fluorescent molecules were proposed. Nile blue phosphorus was used as an alternative sample to determine the ORAC values in fruit juices and wines, and the values obtained were in agreement with the results of the method using fluorescein [14].

Guclu et al. (2014) described ORAC values for some liver and kidney samples meas‐ ured by means of a fluorescent sample, namely p‐aminobenzoic acid (PABA). The authors proposed replacing the fluorescent probe, which was normally fluorescein, with PABA in the ORAC test used for aminoacids, albumin, plasma and for some antioxidants with thiol grouping. Inconclusive results were described for thiol compounds, like glutathion and cystein [15].

Nkhili et al. (2011) stated that it is necessary to continue altering the ORAC method to remove the influence of the metallic ions in the testing systems on the ORAC values measured for the antioxidant compounds. These may lead to the formation of complex combinations with the metallic ions, which results in underestimating their ability to neu‐ tralise peroxyl radicals. Ethylenediaminetetraacetic acid (EDTA) may be useful to attenu‐ ate interferences and in this respect significantly higher ORAC values were reported when using EDTA [16].

In conclusion, this assay measures the oxidative degradation of the fluorescent, $\beta$ ‐ cyclodextrin or fluorescein molecule, after free radical generators, e.g., azo‐initiator com‐ pounds, have been added. Azo‐initiators produce ROO by heating, which harms the flu‐ orescent molecule, leading to the loss of fluorescence. As oxidative degeneration contin‐ ues, the fluorescent intensity decreases, and this intensity is recorded most often for half an hour after the addition of the azo‐initiator as a free radical generator. Antioxidants protect the fluorescent molecule from oxidative degeneration. The degree of protection is quantified using a fluorometer. Currently, fluorescein is most often used as a fluorescent probe. Measuring equipment that can automatically calculate capacity is commercially available.

![](images/0139b7fdc3a169441595a8648907feac210b0d9badad098b75e97e775f8a8582.jpg)  
Figure 3. Reaction schemes involved in Oxygen Radical Absorption Capacity (ORAC) assay for the detection of: (a) hy‐ droxyl and (b) peroxyl radicals.

# 4.1.2. The HORAC Test

This method evaluates the protection ability against the formation of the hydroxyl radical by means a ${ \mathrm { C o } } ( \mathrm { I I } )$ complex. Fluorescein is incubated with the sample to analyse, then the Fenton mixture (generator of hydroxyl radicals) is added. The original fluores‐ cence is measured, then the readings are performed every minute after stirring. Gallic acid standard solutions with different concentrations are used to build the calibration curve. The Hydroxyl Radical Antioxidant Capacity (HORAC) test provides a direct measure‐ ment of antioxidant capacity against hydroxyl radicals by interrupting the radical reaction [17].

# 4.1.3. The TRAP Test

The TRAP test is based on the antioxidants’ capacity to inhibit the reaction between peroxyl radicals and a target molecule, which initially represented the $\mathrm { O } _ { 2 }$ consump‐ tion (as a sample) in the peroxidation process triggered by the thermal decomposi‐ tion of 2,2ʹ azobis(2‐amidinopropane)dihydrochloride (ABAP). The retardation time of the O2 absorption, i.e., the induction period, may be quantitatively measured and used to express the total antioxidant capacity of the samples as the TRAP value [9]. Since then, this method has been modified several times using a wider range of sam‐ ples, initiators and measurements of the final point, for instance the enzymes AAPH and peroxidase were used as initiators, and fluorescein, dihydrofluorescein diacetate (DCFH‐DA) and luminol as measurements of the final points of the reactions [18]. The chemical structure of dihydrofluorescein diacetate and luminol are presented in Figure 4.

![](images/8c4ad7bd37974b424a4aedd9da578f0b13e61daa28a7177bfa48c60cee7dcea4.jpg)  
Figure 4. (1) Dihydrofluorescein diacetate; (2) Luminol.

The TRAP index was defined as the number of mols of ROO• contained per litre of fluid (plasma) [19], according to the equation:

$$
T R A P = R _ { R O O bullet } \times \tau _ { p l a s m a }
$$

where RROO• is the ROO• formation rate, and τplasma is the delay time in the oxygen con‐ sumption generated by the presence of human plasma.

Various methods were proposed to assess the TRAP index for natural products. One of them uses luminol (o‐aminofthalhydrazide) and pyranin (8‐hydroxy‐1,3,6–pyrene tri‐ sulfonic acid) as target molecules. Luminol reacts with ROO•, emitting photons that can be measured by a luminometer, while pyranin oxidation, triggered by ROO•, may be traced by fluorescence measurements [9]. It can be seen that the intensity of the light emis‐ sion during the incubation of luminol with AAPH is directly linked to the stable state concentration of the $\mathrm { R O O } \bullet$ generated in the AAPH thermolysis [9]. In the presence of the phenolic compound (or their complex mixtures), it can be seen that the stable state con‐ centration of ROO• decreases, according to the following equation:

$$
[ \mathrm { R 0 0 \bullet } ] _ { s s } = { \frac { R _ { \mathrm { R 0 0 \bullet } } } { \Sigma \mathrm { k i } } }
$$

where $[ \mathrm { R O O ^ { \bullet } } ] _ { \mathrm { s s } }$ is the stable state concentration of ROO•, RROO• is the formation rate of $\mathrm { R O O ^ { \bullet } } ,$ , and Σki is the rate constant of all the reactions between the phenolic compound and ROO•.

When luminol is used as a target molecule, at high concentrations of the sample un‐ der study (high concentrations of phenolic compound), the TRAP values may be esti‐ mated.

$$
T R A P \ = { \frac { \Sigma { \mathrm { n i } } [ X _ { i } ] } { \Sigma n _ { T R O L O X } } }
$$

where ni is the number of free radicals captured by each i molecule, [Xi] is the micromolar concentration of this component, nTROLOX is the TROLOX equivalent.

Therefore, the TRAP index is directly associated to the stoichiometry of the reaction between the phenolic compound and $\mathrm { R O O } \bullet ( n ) ,$ , which is defined as the number of ROO• molecules captured per molecule by the phenolic compound. In any case, at low concen‐ trations of the sample, when the concentration of the phenolic compound is insufficient for the complete protection of luminol, it may be observed that only the $[ \mathrm { R O O bullet } ] _ { \mathrm { s s } }$ de‐ creases, without the presence of retardation times in the kinetic profiles. Under these cir‐ cumstances, the TAR index may be estimated, as defined by the following equation, re‐ flecting the reactivity of the phenolic compound towards ROO•.

$$
T A R \ = \frac { \Sigma _ { k i } } { k _ { T R O L O X } }
$$

where ki is the ratio between the efficiency of the compound considered and Trolox in decreasing stable state concentrations of the radicals involved in the process.

Depending on the potential applications of the sample studied, either the TRAP or TAR indexes may be used. If the phenolic compound is added in a certain beverage (or oil) to improve its stability, it is important to know the TRAP value of the phenolic com‐ pound included in the sample. However, if this compound will act as a radical capturer in biological systems, its reactivity to ROO• (TAR) should be taken into consideration.

# 4.1.4. The TOSC Test

The TOSC test is based on inhibiting the formation of ethylene (a control reaction is monitored by gas chromatography) in the presence of antioxidant compounds that com‐ pete with $\alpha$ ‐keto $\gamma$ ‐bethiolbutiric acid (KMBA) for ROS. This test uses the area under the ethylene concentration curve in comparison to the reaction time (up to $3 0 0 \mathrm { { m i n } }$ ) [20].

# 4.2. Tests Based On Single Electron Transfer (SET)

The tests based on the transfer of a single electron, also called electron transfer (ET) tests, detect the ability of an antioxidant to transfer an electron in order to reduce metallic ions, carbonyl groups and free radicals [21]. The SET mechanisms of antioxidant action may be summarised by the following reactions:

![](images/840865f5e8ca19daf54cc18edeaad8e3b7222c0afbf01e5fe33d67b28de3d2eb.jpg)

Relative reactivity in SET methods is based primarily on the deprotonation and ion‐ isation potential of the reactive functional group. Therefore, SET reactions are pH depend‐ ent [22]. The aryloxyl radical $\left( \mathrm { A r O ^ { \bullet } } \right)$ is subsequently oxidised to the corresponding qui‐ none $\mathbf { \nabla } \cdot \mathbf { A } \mathbf { r } = \mathbf { O } )$ . The more stabilised the aryloxyl radical, the easier the oxidation from $\mathrm { { A r O H } }$ to $\mathbf { A } \mathbf { r } = \mathbf { O }$ due to the reduced redox potential. The antioxidant action in these tests is often simulated with a suitable fluorescent or coloured sample instead of peroxyl radi‐ cals.

The spectroscopic SET tests, including the Folin–Ciocalteu test (FC), the ferric reduc‐ tion of antioxidant power (FRAP) and the tests of reducing the cupric antioxidant capacity (CUPRAC), measure the capacity of an antioxidant to reduce an oxidant, which changes colour when reduced. The colour change degree is correlated with the concentration of the total antioxidant capacity. Moreover, electrochemical and nanotechnological methods also belong to the category of ST‐based tests.

# 4.2.1. The CUPRAC Test

The CUPRAC assay for determining the total antioxidant capacity was devised in the early 2000s [23], but it has already been modified for various methods of measuring the antioxidant activity based on the reduction of cupric $( \mathrm { C u } ^ { 2 + } )$ to cuprous $( \mathbf { C u } ^ { + } )$ . Similar to other assays, a ligand is employed to form a copper–ligand complex to facilitate absorb‐ ance measurement. Neocuproine $( \operatorname { N c } ; 2 , 9 .$ ‐dimethyl‐1,10‐phenanthroline) is the ligand commonly employed in CUPRAC assay. This method has been applied to various matri‐ ces containing both lipophilic and hydrophilic antioxidants.

This method can be used for the determination of the antioxidant capacity of food constituent by the ${ \mathrm { C u } } ^ { 2 + } .$ –neocuproine reagent as the chromogenic oxidising agent. The re‐ duction of $\mathrm { C u } ^ { 2 + }$ in the presence of neocuproine by a reducing agent yields a $\mathrm { C u ^ { + } }$ complex with maximum absorption peak at $4 5 0 \mathrm { n m }$ (Figure 5). The chromogenic oxidant reagent of the CUPRAC assay, ${ \mathrm { C u } } ^ { 2 + } { \mathrm { - N c } } ,$ reacts with the $\mathbf { n }$ ‐electron reducing antioxidant sub‐ stances (AOX), as shown in the next equation:

$n { \mathsf { C u } } ( { \mathrm { N c } } ) _ { 2 } { \mathrm { ^ { 2 + } } } + n$ -electron reductant $( \mathsf { A O X } )  n \mathsf { C u } ( \mathrm { N c } ) _ { 2 } { } ^ { + } + n$ -electron oxidized product + nH+

In this reducing assay, the reactive Ar‐OH groups of polyphenols and other antioxi‐ dants are oxidised to the corresponding quinones and ${ \mathrm { C u } } ^ { 2 + }$ –neocuproine is reduced to the ${ \mathrm { C u ^ { + } } } .$ –neocuproine complex, which is intensely coloured in yellow–orange. It should be noted that the real oxidant is the $\mathrm { C u } ( \mathrm { N c } ) _ { 2 } { \cdot }$ species and not ${ \mathrm { C u } } ^ { 2 + }$ alone, since the standard redox potential of the Couple (II/I)‐Nc is $0 . 6 \mathrm { V } ,$ , much higher than that of the noncomplexed couple $\mathrm { C u } ^ { 2 + } / \mathrm { C u } ^ { + }$ (0.17 V) [9]. The main antioxidants in foodstuffs and biological com‐ pounds have a redox potential corresponding to the range of $0 . 2 \mathrm { - } 0 . 6 \mathrm { ~ V ~ } ,$ , according to that of the redox couple $\mathrm { C u ( I I / I ) \mathrm { - N c } }$ .

Reduced CU‐ PRAC Reagent (Yellow‐orange)

![](images/152329d70ffc06f34364547f87c5b3f3ebae52d0ffc25bf146c77b0ff1e02263.jpg)  
Figure 5. Reaction scheme involved in Cupric Reducing Antioxidant Power (CUPRAC) assay. HA represents an antioxi‐ dant molecule and $\mathrm { A ^ { + } }$ an oxidised antioxidant molecule; Colour change in the assay.

Taking into account the favourable attachment of the cupric state with neocuproin, the quantity of chromophore product occurring at the end of the reaction equals that of Cu (II)‐Nc. The released protons are buffered in a solution containing ammonium acetate, with $\mathrm { p H }$ of 7.0. This $\mathrm { p H }$ is optimum for CUPRPAC assay because it is very close to the physiological $\mathrm { p H }$ (7.4).

For some specific compounds, including epicatechin galate, rosmarinic acid, querce‐ tine, epigalocatechin, catechin, acid caffeic acid, epicatechin, gallic, rutin, and chlorogenic acid [24,25], the best antioxidant capacities were noted using the CUPRAC method. This was possible because an optimal transfer of the electrons depends on the number and orientation of the hydroxyl groups and, also, on the degree of conjugation of the entire molecule [26].

Despite the fact that there are other derivatives of phenantrolin that may selectively stabilise the $\mathbf { C u ^ { + } }$ ion in relation to the $\mathrm { C u } ^ { 2 + }$ ion, among which are BCS (2,9‐dimethyl‐4,7‐ diphenyl‐1,10‐phenanthroline disulfonic acid ) [27] and bicinconinic acid (BCA: 2‐ (4‐car‐ boxyquinolin‐2‐il) chinolin‐4‐carboxylic acid) [28], only neocuproin as a primary ligand for the CUPRAC assay is widely used in measuring antioxidant capacity. It is worth men‐ tioning that BCS and BCA have particular disadvantages in comparison to Nc. First of all, due to the presence of negatively charged sulfonate groups on the fenantrolin ring, the $\mathrm { C u ( I ) } { \cdot } \mathrm { B C } S$ complex has a higher global charge than the $\mathrm { { C u ( I ) } }$ –Nc complex. Ion–dipol in‐ teractions with water molecules cause reverse addiction—proportional between the charge on the chromophore and its affinity for hydrophobic expulsion. Therefore, $\mathrm { { C u ( I ) - } }$ BCS will unavoidably have a lower permeability of the membrane, which is why it will be less frequently used as a TAC reagent in nonpolar solvents compared to copper–Nc.

In terms of reaction kinetics and the answer to the antioxidant compounds of the lipophilic plasma (for instance, $\beta$ ‐carotene, $\alpha$ ‐tocopherol), from Çelik et al.ʹs (2012) point of view, the $\mathrm { C u ( I ) } { \cdot } \mathrm { B C } S$ test cannot be compared practically with CUPRAC assay [29].

Zhou et al. (2012) showed that the reduction potential for the $\mathrm { C u ( I , I I ) }$ –BCS couple had the value of: $\mathrm { E } ^ { \circ } = 0 . 8 4 4 \ : \mathrm { V }$ [30], slightly higher than the ones of the most common ET reagents. This can negatively influence selectivity for genuine antioxidant substances.

On the other hand, even if BCA has a higher wavelength of maximum absorption, which is apparently advantageous $( 5 5 8 \ \mathrm { n m } )$ , as compared to Nc for its cupric complex (which allows the removal of the background colour from most plant pigments), it was noticed that, while conducting the BCA test, the concentration of free cupric ions cannot be preserved in excess [31].

Moreover, it was reported that the results obtained from in vitro cupric ion $( \mathrm { C u } ^ { 2 + } )$ reducing measurements might be more efficiently extended to the possible in vivo reac‐ tions of antioxidants. CUPRAC chromogenic redox reaction is carried out at a $\mathrm { p H }$ (7.0) close to the physiological $\mathrm { p H } ,$ which has a value of 7.4. Reaction time to reach completion may vary between 30 and $6 0 \mathrm { { m i n } } ,$ depending on how fast the antioxidant is. For instance, flavonoid glycosides may require preliminary hydrolysis to fully highlight their antioxi‐ dant capacity.

The original CUPRAC test was modified to include various samples in diverse ap‐ plications. For example, the acetone/water environment, with the help of methyl $\cdot \beta \cdot$ ‐  cy‐ clodextrine, was used to simultaneously determine hydrophilic and lipophilic antioxi‐ dants [32]. In order to evaluate phenolic antioxidants in free forms, as well as in tied forms in the food matrix without preliminary extraction and reducing the intricate hydrolysis process, a proposition was made to forcefully solubilise the antioxidants attached to the CUPRAC reagent, which has advantages as a result of the phenomenon of superficial re‐ action between the solid material (tied antioxidants) and the liquid material (soluble CU‐ PRAC reagent) [33]. This modified method was suggested as applicable to relatively in‐ soluble food matrices, as well as insoluble cosmetic products, such as creams, balms and powders.

In another modified CUPRAC test, an optical sensor was modified to contain immo‐ bilised chromogenic redox reagent to measure the reduction power of liquid samples without any pretreatment [25]. The CUPRAC ${ \mathrm { C u } } ^ { 2 + } .$ –neocuproin reagent was immobilised on a cation‐changing Nafion film, and the complex was reduced by antioxidants to $\mathrm { C u ^ { + } { - } }$ neocuproin, yielding modifications of absorbance at $4 5 0 \mathrm { n m } ,$ , which were monitored spec‐ trophotometrically. Another version of the optical sensor aiding the CUPRAC test used a miniaturised reflection spectrophotometer to measure the changes of reflection at $5 3 0 \mathrm { n m }$ instead of absorbance [34].

The use of the optical sensor was suggested so to considerably simplify operation, as it is reliable and robust, and therefore able to allow for the in situ estimation of the anti‐ oxidant capacity of the various food extracts and biological samples.

The CUPRAC test, together with its adjustments for the measurements aimed at elim‐ inating reactive species of oxygen, was analysed and certain advantages were highlighted in comparison to other ET‐based assays, in an extensive analysis performed by Özyürek et al. (2011) [35].

 The CUPRAC reagent is fast enough to oxidise thiol‐type antioxidants, while other ET assays based on Fe(III), such as the FRAP method, do not allow the measurement of certain tiol antioxidants, such as glutathione. The reason for this may be the elec‐ tronic structure of $\operatorname { C u } ( \operatorname { I I } )$ that enables fast kinetics.   
 Favourable $\mathrm { p H }$ : the redox reaction producing coloured species is carried out at pH 7.0 buffer as opposed to the acidic conditions $\mathrm { ( p H } 3 . 6 )$ of FRAP, or basic conditions $\mathrm { ( p H 1 0 . 0 ) }$ of the Folin–Ciocalteu assay. At more acidic conditions than the value of 7.4 corresponding to the physiological $\mathrm { p H } ,$ the reducing ability may be suppressed. The reason for this is the protonation on antioxidant compounds while, in more basic conditions, acid dissociation (through proton release) from phenols improves the re‐ duction capacity of a sample, thus triggering unrealistic measurements of TAC. Favourable redox potential: the CUPRAC reagent is selective, because it has a lower redox potential than that of the ferric–ferrous couple in the presence of phenanthro‐ line—or similar ligands. The standard potential of the Cu(II,I)–Nc redox couple is about $0 . 6 \mathrm { V } ,$ , close to that of ABTS+/ABTS, i.e., 0.68V. Due to the fact that simple sugars and citric acid are not true antioxidants, these compounds cannot be oxidised with the CUPRAC reagent. Stability and facility: the reagent is more stable and accessible than other chromo‐ genic reagents (e.g., ABTS, DPPH). Versatility: this method is capable of measuring both hydrophilic and lipophilic an‐ tioxidants (e.g., $\beta$ ‐carotene and $\alpha$ ‐tocopherol). The lipophilic antioxidants of serum may be assayed separately from the hydrophilic ones by hexane extraction of serum, followed by colour development in dichloromethane. As an advantage over the widely used Folin–Ciocalteu reagent, CUPRAC can measure lipophilic antioxidants, while FCR cannot be used for TAC assay of biological fluids. According to a comprehensive review compiled by Christodouleas et al. (2014), lip‐ ophilic antioxidant substances in edible oils may be efficiently analysed in order to obtain the TAC values by means of the $\operatorname { C u } ( \operatorname { I I } )$ –Nc reagent [36]. Robustness: it is observed that physiological parameters, such as air, humidity, sun‐ light do not influence the CUPRAC reaction with antioxidants, as opposed to the reagents of the free radical type, such as DPPH. Sensitivity and linear response: the absorbance vs. concentration curves are linear in the CUPRAC method over a wide range, unlike those of other methods yielding pol‐ ynomial curves. The molar absorptivity, i.e., $( 7 . 5 - 9 . 5 \times 1 0 ^ { 3 } n _ { . }$ ) $\mathrm { L m o l ^ { - 1 } c m ^ { - 1 } }$ for n‐electron reductants, is sufficiently high to sensitively determine biologically important anti‐ oxidants.   
 The TAC values of antioxidants found with CUPRAC are perfectly additive, i.e., the TAC of a mixture is equal to the sum of TAC values of its constituents. Unfortunately, because of the fact that the oxidation reactions cannot be controlled, the additive property of antioxidant capacities cannot be ensured for complex mixtures in various similar TAC tests (for example, thiol compounds showed a lack of additivity with a number of polyphenol compounds in FRAP responses) [29].   
 Absence of prooxidative behaviour: since the $\mathrm { { C u ( I ) } }$ ion emerging as a product of the CUPRAC redox reaction is in chelated state (i.e., $\mathrm { C u ( I ) \mathrm { - N c ) } }$ , it cannot act as a prooxi‐ dant that may cause oxidative damage to biological macromolecules in body fluids. The stable ${ \mathrm { C u ( I ) } } .$ –chelate does not react with hydrogen peroxide, but the reverse re‐ action, i.e., oxidation of $_ { \mathrm { H } _ { 2 } \mathrm { O } _ { 2 } }$ with ${ \mathrm { C u ( I I ) } } - { \mathrm { N c } } ,$ is possible. Thus, $\mathrm { { C u ( I ) } }$ chelated to $\mathrm { N c }$

may not act as a prooxidant toward the tested antioxidants in a Fenton‐type reaction in the absence of $\mathrm { H } _ { 2 } \mathrm { O } _ { 2 }$ or its precursors.  The method is easily and diversely applicable in conventional laboratories using standard colorimeters rather than necessitating sophisticated equipment and quali‐ fied operators [37]. Applicability in foods and medicine: according to the research teams coordinated by Gorinstein et al. (2006), the CUPRAC test showed repeatable results in point of real $\mathrm { p H }$ and the redox potential for certain diversified food extracts, among which kiwi, garlic, and onion [38]. Bean and his team (2009) described a comparative analysis on antioxidant reactivity within the obstruction and control of bladder tissue in rabbits, involving two different TAC tests. The CUPRAC test, unlike the FRAP test, detected a considerable decrease in the antioxidants found in the obstructed bladder tissue as compared to the control bladder tissue in both the muscles, and the mucous mem‐ brane. Bean et al. (2009) concluded that the CUPRAC test was receptive to hydro‐ philic, lipophilic antioxidants, and antioxidants containing thiol at physiological $\mathrm { p H } ,$ and as a result, it was a much better tool for the analysis of antioxidant reactivity in tissues [39].

# 4.2.2. The FRAP Test

The FRAP test is a typical SET‐based method measuring the reduction of the complex of ferric ions $( \mathrm { F e } ^ { 3 + } )$ ‐ligand to the intensely blue ferrous complex $( \mathrm { F e } ^ { 2 + } )$ by means of antiox‐ idants in acid environments. Antioxidant activity is determined as an increase in absorb‐ ance at $5 9 3 \mathrm { n m }$ , and the results are expressed as micromolar equivalents of $\mathrm { F e } ^ { 2 + }$ or in rela‐ tion to a standard antioxidant [5]. Unlike other SET‐based methods, the FRAP test is car‐ ried out in acidic $\mathrm { p H }$ conditions $\mathrm { ( p H } = 3 . 6 )$ to maintain iron solubility. Reaction at low $\mathrm { p H }$ decreases the ionisation potential that drives electron transfer and increases the redox po‐ tential, causing a shift in the dominant reaction mechanism [40].

The original FRAP test uses tripyridyltriazine (TPTZ) as the linking ligand to the iron ion, while alternative ligands were also used to bind the iron ion, such as ferrozine to assess the reducing power of ascorbic acid [41].

More recently, potassium ferricyanide has been the most common ferric reagent used in FRAP tests. In this latter case, Prussian blue is obtained as a final product that may be quantified spectrophotometrically and shows the reducing power of the antioxidants tested. The formation of Prussian blue may occur in two different manners with the same result. Antioxidants can either reduce the $\mathrm { F e } ^ { 3 + }$ in the solution to $\mathrm { F e } ^ { 2 + }$ , which binds the fer‐ ricyanide to yield Prussian blue, or reduce the ferricyanide to ferrocyanide, which binds the free $\mathrm { F e } ^ { 3 + }$ in the solution and forms Prussian blue.

Figure 6 shows the simplified scheme for these two reactions (A) and the colour change together with the mechanism of reaction (B) [42]:

![](images/0b84ba01d749e864cf3681b2582734f37c1e25d2a5ba595cdfb551fcc4837cfa.jpg)  
Figure 6. Ferric reducing antioxidant power (FRAP) reaction mechanism. ArOH represents a phe‐ nolic antioxidant and $[ \mathrm { A r O H } ] ^ { + }$ an oxidised phenolic antioxidant (A); Chemical structure of the complexes involved in the chemical reaction and the colour change (B).

A disadvantage of this FRAP test is the tendency of Prussian blue to precipitate, to form a suspension and stain the measurement vat. Therefore, the time to add $\mathrm { F e ^ { 3 + } }$ (FeCl3) is essential and may produce errors in the interpretation of the results. In order to stabilise Prussian blue against precipitants, Berker et al. (2010) proposed adding sodium dodecyl sulphate, a tensioactive compound, and an optimal pH in order to maintain the redox activity of the ferric ion and prevent the hydrolysis process [42]. The authors suggested that this modification also allows the evaluation of the antioxidants, whose redox poten‐ tial does not exceed the one of $\mathrm { F e ^ { 3 + } / F e ^ { 2 + } }$ in the conventional FRAP test, such as thiol‐type physiological antioxidants. The FRAP test was further modified by selecting water/ace‐ tone as solvent in the absence of the randomly methylated $\beta \cdot$ ‐cyclodextrine (RMCD) solu‐ bility potentiator to allow the simultaneous measurement of hydrophilic and lipophilic antioxidants, which was restricted in the conventional FRAP test [43].

The FRAP test is simple, fast and cost‐effective, and does not require specialised equipment. However, Pulido, Bravo and Saura‐Calixto (2000) reported that the FRAP re‐ sults may vary according to the observed analysis time for the reaction between the anti‐ oxidants and $\mathrm { F e ^ { 3 + } }$ , which ranged from a few minutes to several hours [44]. Therefore, a single‐point absorption endpoint may not represent a complete reaction, since various an‐ tioxidants require different reaction times for detection [8].

The FRAP test has recently adopted electrochemical detection techniques for better sensitivity, accuracy and reproducibility. A new method of coulometric titration was de‐ veloped, to determine the FRAP value of different antioxidant materials [45]. In this mod‐ ified FRAP method, the antioxidant reacts with the coulometric titrants (electrogenerated ferricyanide ions), and the amount of electrical energy consumed for titration up to the final point (when the initial current is resumed) serves as an indicator for the reduction of the antioxidant power [46]. The FRAP test by coulometric titration stands out by being extremely sensitive, reliable and simple in assessing reductive power. Another electro‐ chemical version of the FRAP test is the chronoamperometric measurement of the antiox‐ idant’s reducing power. As proved by Brainina, Varzakova and Gerasimova (2012), a change in the potential of the $\mathrm { K } _ { 3 } [ \mathrm { F e ( C N ) _ { 6 } ] / K _ { 4 } [ \mathrm { F e ( C N ) _ { 6 } ] } }$ system is indirectly correlated to the reducing power of the antioxidant present. More precisely, at certain potentials (higher than $0 . 3 5 \mathrm { V } ,$ ), the oxidation process takes place only forming ${ \mathrm { K } } _ { 3 } [ { \mathrm { F e } } ( { \mathrm { C N } } ) _ { 6 } ] ,$ and the concentration of ${ \mathrm { K } } _ { 4 } [ { \mathrm { F e } } ( { \mathrm { C N } } ) _ { 6 } ]$ is entirely from the reaction of ${ K _ { 3 } } [ \mathrm { F e } ( \mathrm { C N } ) _ { 6 } ]$ with the antioxi‐ dant, being proportional to the antioxidant’s reducing power [47]. This chronoam‐ perometric method was proposed to assess the antioxidant activity of biological samples due to its good detection limit (e.g., $2 { \times } 1 0 ^ { - 6 } \mathrm { M }$ for ascorbic acid).

Generally, the FRAP test, as a non‐radical SET‐based method, was promoted as hav‐ ing a low relation with the process of radical extinction (the HAT mechanism) occurring in lipid systems and has a low correlation with other antioxidant activity measurements. As a result, it is suggested that this test may be used together with other methods to dis‐ tinguish the dominant mechanisms for different antioxidants [8].

Ascorbic acid (vitamin C) is an important physiological antioxidant [48]. Many plants are rich in vitamin C and are important dietary agents, as people must ingest vitamin $C ,$ but cannot synthesise or store it. A simple adjustment of the FRAP test allows the meas‐ urement of the ascorbic acid in the same sample and in the same manner as the FRAP test [49]. The modified test is known as the analysis of the reducing ferric and ascorbic acid antioxidant power, called FRASC, and was validated in comparison to a reference HPLC method [50,51].

The concept of redox reducing capacity as an index of antioxidant activity may be applied in different manners. There are several tests based on transitional metals (iron and copper), like those using ferricyanide, ferrozine, Prussian blue or cupric ions instead of Fe–TPTZ [52]. In addition, the methods which were developed use changes of the redox electrochemical signals [9]. However, the FRAP test is the most common; it is well vali‐ dated and has generated large amounts of data on foods, beverages, body fluids and other types of samples. Various modifications were introduced by various users. These are usu‐ ally small, involving modifications of $\mathrm { p H } ,$ temperature, calibration method, reaction du‐ ration and reporting units. However, the variations that occur make it difficult to compare the results of different studies. Thus, except for the existence of an imperative reason for changing the reaction conditions for an experimental series or a certain sample type, the FRAP test should use a standard operating procedure, so that the results may be inter‐ preted in association with the data published using the same method for the index of total antioxidant activity (NEAC). If modifications are operated at the level of the reaction con‐ ditions or duration, standardisation or the manner of expressing the results, then it is im‐ portant that they should be justified and clearly described, and the modified method should be validated in comparison to the standard procedure.

The FRAP test is used globally on a large scale, providing results for a variety of purposes, including the estimation of the antioxidant content in foods and their contribu‐ tion to the supply of antioxidants, to investigate the effect of storage, growth, draught, solar radiation, processing, genetic modification of dietary agents and petfoods, and to compare the relative content of antioxidants in foods, medicines, traditional medicines, herbs, spices, teas and wines for product differentiation, quality, control and develop‐ ment.

The FRAP test may be also used to detect water contamination, and was used to study the effect of radiations, pollution, climate change and space travel on living organ‐ isms. The high sensitivity and accuracy of the test allow discrimination among samples, which was used in assessing antioxidant absorption and systemic distribution (“bioavail‐ ability”) after ingesting foods, beverages, medicines or supplements.

F.T. Pastor et al. (2020) examined the applicability of the reduction reaction of Fe(III) to $\mathrm { F e ( I I ) }$ by the antioxidants in order to develop the electrochemical method of determin‐ ing antioxidant activity, applying direct current polarography and cyclic voltammetry. The redox $\mathrm { F e ( I I I ) / F e ( I I ) }$ system was chosen not only because it is the basis for the simplest spectrophotometric test for antioxidant activity measurement, but also because it is the standard reversible redox system in chemistry. Developed in a fast and simple manner, and lacking the need for calibration according to a standard (like Trolox or gallic acid), electrochemical methods were applied to measure the antioxidant activity for ten natural antioxidants. The results obtained were compared to the antioxidant activity of the same antioxidants, measured by means of the FRAP, ABTS and DPPH tests [53].

Furthermore, the FRAP test was widely used to investigate the effects of lifestyle, diet, supplements, pregnancy, age, gender, disease, medical treatment, traditional/alter‐ native therapies on the total antioxidant activity of biological fluids, including plasma, urine, saliva, follicular fluid, alveolar liquid, seminal material, tears, cerebrospinal fluid, and faeces. In the biomonitoring and supplementary studies, the FRAP test was used in human investigations, as well as on samples from various animals, insects, and marine organisms.

# 4.2.3. The Folin–Ciocalteu Method

The Folin–Ciocalteu test is a well‐known method aimed at determining the total phe‐ nolic content (TPC). The Folin‐Ciocalteu test was widely used in clinical and nutritional studies to measure the total polyphenolic content in plant‐derived foods and biological samples. This method was originally designed to analyse proteins, but it was later adopted by Singleton, Orthofer and Lamuela‐Raventos (1999) in order to analyse the phe‐ nolic components in wine, after which it became a routine test for the antioxidant evalua‐ tion of food and plant extracts [54].

At present, the Folin–Ciocalteu test is commercially available from several important commercial societies, so this method is widely used to quantify polyphenols in plant‐de‐ rived extracts [55], as well as in foods and beverages [9]. The pharmacopoeia includes the Folin–Ciocalteu test [9], and Europe adopted it as an official procedure of measuring the total phenol contents in wines (European Community 1990).

The Folin–Ciocalteu test is based on reducing the Folin–Ciocalteu reagent with phe‐ nolic compounds in an alkaline state. The exact chemical nature of the Folin–Ciocalteu reagent is not clearly defined, but it is believed that it may contain a complex of the phos‐ phomolybdic/phosphotungstic acid which are reduced to obtain a blue chromophore with the maximum absorption at $7 6 5 ~ \mathrm { n m }$ (Figure 7) [56]. The central molybdenum ion in the complex is accepted as a reducing site, where the ${ \bf M o } ^ { 6 + }$ ion is reduced to ${ \mathrm { M o } } ^ { 5 + }$ by accepting an electron donated by the phenolic antioxidant. The anionic derivatives of the phospho‐ tungstic and phosphomolybdic acids have an $\alpha$ ‐Keggin structure and the blue complex has a big wheel structure Mo154—of the cluster‐type (Figure 8) [57].

Thus, the Folin–Ciocalteu test is an SET‐based test, and it is associated to the reducing power of phenolic antioxidants. Gallic acid is the commonly used reference standard, and the TPC results are usually expressed as Gallic acid equivalent. However, the TPC results are also occasionally expressed as catechins, caffeic acid, chlorogenic acid or the equiva‐ lent of ferrulic acid, requiring the standardisation of the reported results [58].

![](images/a2b08d81e841750ab276fa487b42fc2f6f8da502b711e9bbaf039d28d4b24b37.jpg)  
Figure 7. Reaction between the phenolic compounds and the derivatives of the phosphotungstic and phosphomolybdic acids in an alkaline environment, resulting in the formation of a blue colour by the Folin–Ciocalteu method (a); Colour variation observed in the assay (b).

![](images/a53dfdd79bc23d77ee651915f7e6515326eb7143fc3821102b31b72a12af936f.jpg)  
Figure 8. (A) The $\alpha$ ‐Keggin structure of the anionic derivative $[ \mathrm { P M } _ { 1 2 } \mathrm { O } _ { 4 0 } ] ^ { 3 - }$ , where M stands for mo‐ lybdenum (Mo) or tungsten (W); (B) the big wheel structure of the blue complex $\mathrm { [ M o _ { 1 2 6 } { } ^ { 6 + } M o _ { 2 8 } { } ^ { 5 + } O _ { 4 6 2 } H _ { 1 4 } ( H _ { 2 } O ) _ { 7 0 } ] ^ { 1 4 - } }$ .

The Folin–Ciocalteu assay for TPC measurement has numerous advantages, includ‐ ing simpleness, reproducibility and robustness. However, it also has some drawbacks. First of all, the test is sensitive to $\mathrm { p H } ,$ temperature and reaction time, and that is why it is necessary to accurately select the reaction state for coherent and reliable results. Secondly, TPC overestimation is a major concern for the Folin–Ciocalteu test, owing to the contribu‐ tion of the non‐phenolic reducing agents present in the system when reducing the Folin– Ciocalteu reagent [59]. Such examples of contaminants include reducing sugars and cer‐ tain amino acids. Thus, the results of TPC measurements may be overestimated by one size for comparison to the ones obtained by HPLC methods. Additionally, the test is per‐ formed in aqueous systems, and its application for lipophilic phenols is limited, except for the case when modifications of the solvent system are applied.

To improve the durability and reduce the cost and time of the Folin–Ciocalteu test, a methodology for microtitre 96 plates was devised for food samples [60] and urine samples [61].

The level of polyphenols in urine measured by the Folin‐Ciocalteu test was used as a biomarker of the polyphenol supply and correlated to a decrease in the cardiovascular risk parameters, such as high blood pressure, an increase in the nitric oxide as a potentially relaxing agent [62], improvements of the lipid profile and the glucose response [63] and a decrease in DNA oxidation. Another advantage was improved cognitive performance, which was associated to an increased supply of polyphenol‐rich foods [64].

An evaluation of the antioxidant capacity of polyphenols according to their chemical structures was carried out by B. Alcalde et al. (2019). Several tests were employed, among which were Folin–Ciocalteu (FC), FRAP and TEAC to select the polyphenols differing in number and position of the hydroxyl groups. Voltammetric methods with screen‐printed carbon electrodes were also recorded within the range ‐0.2 to $0 . 9 \mathrm { V }$ (vs. the $\mathrm { A g / A g C l }$ ref‐ erence electrode) to investigate the oxidation behaviour of these substances. Weak corre‐ lations among tests were obtained, which means that each compound had a behaviour that varied as a response to the different methods used [65].

# 4.3. Mixed Mode Tests (HAT/SET)

These mixed mode tests are generally based on the elimination of a stable chromo‐ phore (like $2 , 2 ^ { \prime }$ ‐azinobis‐3‐ethylbenzthyazolin‐6‐sulfonic acid) (ABTS) and 2,2‐diphenyl‐ 1‐picrylhydrazil (DPPH)), where HAT, ET, and proton‐coupled electron transfer (PCET) mechanisms may play different roles in varied proportions, depending on the correspond‐ ing reaction conditions (such as $\mathrm { p H }$ and solvent) [66]. Mixed mode tests (HAT/SET) mainly include the ABTS/Trolox equivalent antioxidant capacity (TEAC) test, the DPPH radical neutralisation test, and the N,N‐dimethyl‐p‐phenylenediamine dihydrochloride (DMPD) radical neutralisation test.

# 4.3.1. The ABTS (TEAC) Test

The TEAC test was first developed by Miller and his team (1993) as a simple and convenient method used to measure the total antioxidant capacity (TAC) [67]. the test measures the antioxidants’ capacity to neutralise the $2 , 2 ^ { \prime } .$ ‐azinobis(3‐ ethylbenzthiazolin‐ 6‐sulfonic acid) $( \mathrm { A B T S ^ { \bullet + } } )$ stable radical cation, a blue‐green chromophore of maximum absorption at $7 3 4 \mathrm { n m } ,$ whose intensity decreases in the presence of antioxidants. $\mathrm { A B T S ^ { \bullet + } }$ may be generated from ABTS in the presence of powerful antioxidant agents. The degree of discolouration of the blue–green colour, quantified as a sudden drop in absorbance to $7 3 4 \mathrm { n m } ,$ , depends on the reaction duration, intrinsic antioxidant activity, and sample con‐ centration (Figure 9).

In the original TEAC test, metmyoglobin and hydrogen peroxide are used to generate an intermediate radical of ferrylmyoglobin, which subsequently reacts with ABTS to pro‐ duce $\mathrm { A B T S ^ { \bullet + } }$ . Later on, the oxidant agent was replaced with peroxide or persulphate. Po‐ tassium persulphate is the most common oxidant for ABTS•+ generation.

As can be seen in the reactions below, in the system formed by ABTS/H2O2/peroxi‐ dase, ABTS behaves as a reducing agent, substituting the enabled form of the enzyme (named compound I) in compound $\mathrm { I I } ,$ which returns to the initial form of the enzyme (E).

Compound $\Pi + { \sf A B T S } \longrightarrow \mathbb { E } + { \sf A B T S } ^ { \bullet + }$

ABTS is oxidised by oxidants to its radical cation, $\mathrm { A B T S ^ { \bullet + } }$ which is intensely coloured in blue–green. Furthermore, the ABTS radical is soluble in water and organic solvents, enabling the determination of antioxidant capacity of both hydrophilic and lipophilic compounds.

![](images/dba51644d4045496cc76e8f5875cfaaff94b795b7d8be23312a44f32d0b15956.jpg)  
Figure 9. Colour variation in ABTS assay (a); Reaction scheme involved in $2 , 2 ^ { \prime }$ ‐Azinobis‐(3‐ethylbenzothiazoline‐6‐sulfonic acid (ABTS) radical cation scavenging activity assay (b).

Durmaz (2012) prepared a ready‐to‐use ABTS•+ radical powder by incubating ABTS with potassium peroxodisulphate, followed by drying and freezing the resulting solution [68]. This lyophilised radical powder was then used as a replacement for the freshly pre‐ pared solution, and the linearity and accuracy of the modified test were proven by the authors.

Bleaching of a preformed solution of the blue–green radical cation ${ \mathrm { A B T S ^ { + } } }$ has been extensively used to evaluate the antioxidant capacity of complex mixtures to induce the oxidation reaction of aromatic alcohols, with corresponding aldehyde formation. In addi‐ tion, ABTS has been used to determine p‐hydroxybenzoic acids and polyphenolic com‐ pounds by means of the enzyme laccase [69,70] and, also, to determine a variety of flavo‐ noids using peroxidase [71]. In both situations, as a result of the enzymatic reaction, an ABTS–polyphenol complex is formed.

The TEAC test was used to measure the total antioxidant capacity of pure substances, corporal fluids and vegetable materials. The TEAC test, similar to other methods of radical neutralisation, may be automated and adapted to microplates and flow injection tech‐ niques. It may also be coupled with HPLC by including a post column reaction with the ABTS radical–cation to facilitate the identification of individual antioxidants in a complex mixture. HPLC–TEAC provides a fast and effective method of separation and identifica‐ tion of the bioactive compounds in the source material [72]. A higher sensitivity and effi‐ ciency of the TEAC test may be achieved when the method is coupled with other detection techniques, like amperometry [73] and FTIR [74]. Many of these modified TEAC assays use the online enzymatic generation of ABTS•+, mainly those employing continuous flux systems. For example, Milardovic et al. (2007) reported generating $\mathrm { A B T S ^ { \bullet + } }$ by glucosoxi‐ dase and peroxidase separately immobilised in tubular flow reactors for the analysis of the TEAC values of alcoholic beverages [75].

ABTS radical scavenging method can be evaluated over a wide $\mathrm { p H }$ range, which is useful to study the effect of pH on antioxidant mechanisms for food components. Further‐ more, the ABTS radical is soluble in water and organic solvents, enabling the determina‐ tion of antioxidant capacity of both lipophilic and hydrophilic compounds. In the case of lipophilic compounds, such as carotenoids, tocopherols, etc., homogeneous solutions were used to assess the degree and protective capacity of lipid‐soluble antioxidants on lipids.

According to the protocol developed by Miller et al. [76] regarding the estimation of the antioxidant activity of carotenoids, these substances were dissolved in acetone and diluted in a mixture of hexane and acetone $_ { ( 9 0 : 1 0 \mathrm { ~ v / v ) } }$ , using manganese dioxide as a re‐ action medium. Böhm et al. (2002) changed this method by using hexane as solvent for dissolving carotenoids. This dissolution stage was followed by centrifugation and meas‐ urement of the inferior blue–green hydrophilic layer’s absorbance [77]. However, these tests occasioned the occurrence of serious reactivity issues between the carotenoids and $\mathrm { A B T S ^ { \bullet + } }$ in aqueous environment [78].

Based on the capacity of the horseradish peroxidase enzyme to operate in organic environments, Cano et al. (2000) described a method that involves the direct production of cation in such environments [79]. Various solvents were used, like methanol, ethanol, acetone and dimethylsulfoxide, subsequently establishing the kinetics of the reaction and also the stability of the radical. The time to generate the ABTS•+ radical by peroxidase en‐ zyme was approximately ${ 1 0 0 s , }$ using ethanolic media. The shortcoming in this activity to generate the radical $\mathrm { A B T S ^ { \bullet + } }$ has been linked to its solubility in such environments [80]. The total antioxidant activity (TAA) of both hydrophilic and lipophilic compounds has been determined by combining lipophilic antioxidant activity (LAA) and lipophilic activ‐ ity (LAA) through the ABTS•+ radical cation.

Puangbanlang et al. (2019) reported the first use of a paper‐mounted device as a sim‐ ple, cheap and fast detection platform for the simultaneous determination of the antioxi‐ dant activity and the total phenolic content in food samples. Two antioxidant activity tests, including the analysis of the cation radical (ABTS) and the analysis of the reducing anti‐ oxidant capacity of the cupric ion (CUPRAC), as well as a test for the total phenolic con‐ tent, the Folin–Ciocalteu test (FC), were used at the same time. The device consisted of a central sampling area connected to four consecutive pre‐treatment and detection areas hosting all the three tests and a witness measurement of the sample. The test was per‐ formed by fixing the samples in the sampling area in order to flow through the pre‐treat‐ ment and detection areas containing the reagents stored for each antioxidant test, trigger‐ ing the colour change which was measured photocolourimetrically. Test optimisations included the concentrations of the key reagents, reaction time and surface adjustment, being performed to obtain sensitive tests, with wide linearity domains. Various antioxi‐ dant standards were subsequently evaluated in order to determine the analytic character‐ istics of the method. The paper‐based tests were successfully applied to detect the antiox‐ idant activity and total phenolic content in 10 beverages with Gallic acid equivalent values (GAE) similar to those obtained in traditional tests, with a confidence interval of $9 5 \%$ . In addition, the GAE values of the samples obtained as a result of the three analyses of the paper‐based test were well correlated among themselves with relatively high Pearson cor‐ relation coefficients. These results showed that the paper‐based test yielded accurate re‐ sults and is suitable for the simultaneous analysis of the antioxidant activity and total phenolic content in real samples [81].

# Advantages of the ABTS Test

TEAC tests allow the determination of a large variety of antioxidant substances, since ABTS•+ radical reacts rapidly with both synthetic and natural antioxidant substances

(i.e., phenols, amino acids, peptides, vitamin E and vitamin C) in food components [82].   
The TEAC antioxidant test may be used over a wide pH range, although, in many cases, the sample for which antioxidant activity is measured may influence the pH value [83]. This is due to the fact that the reaction mechanism may vary with pH, e.g., the electron transfer is facilitated by acid conditions [84].   
ABTS•+ solubility in buffered and organic environments led to the development of methods for the determination of hydrophilic and lipophilic antioxidant activity [80], whose sum yielded an accurate determination of the antioxidant capacity of the prod‐ ucts [85].   
The TEAC assay is cheap and operationally simple.

Disadvantages of The ABTS Test

In kinetic tests, the reaction involved in the TEAC test is uncertain because the test substance can react with the oxidiser, the enzyme and the radical cation, thus obtaining an overrated value [86]. While the discolouration test may solve this problem, other dis‐ advantages occur because of the problems of procedure and mechanism [87].

The TEAC assay has also been challenged for its lack of biological relevance due to use of the artificial ABTS radical cation that is not found in food or biological systems [88].

Many phenolic compounds have low redox potentials and, therefore, can react with $\mathrm { A B T S ^ { \bullet + } }$ . Additionally, the TEAC reaction may be different for slow reactions, and it may take a long time to reach an endpoint. In such cases, using an endpoint of short duration (4 or 6 min), may lead to underestimation of the antioxidant capacity due to reading before the reaction is finished [89].

# 4.3.2. The DPPH (2,2‐di(4‐tert‐octylphenyl)‐1‐picrylhydrazyl) test

Characteristics of The DPPH Radical

DPPH• is a $\pi$ ‐radical, present in its monomer form in a solid state, as well as in so‐ lution. The first structural data showed that its unique low reactivity was mainly influ‐ enced by the “efficient screening of the hydrazyl structure by the molecule’s surrounding parts” and less by extended conjugation [90]. It was confirmed that, although the removal of the p‐nitro group only has a slight influence, the removal of the group responsible for protecting the o‐nitro groups led to a significant reactivity increase. Moreover, the fact that both phenyl groups are twisted has an adverse effect on conjugation stability.

The radical is soluble in different organic solvents, but not in water. It usually dis‐ solves in methanol, ethanol, or their aqueous mixtures. In this final case, the water content should not exceed $6 0 \%$ to make the radical more readily soluble [91]. At a high water content, the typical quintet spectrum of the dissolved DPPH• is converted to singlet, typ‐ ical for a solid state radical. Such a modification of radical solubility is not always visible.

The neutralisation DPPH test is based on donating electrons from the antioxidants in order to neutralise the DPPH radical. The reaction is accompanied by changing the DPPH colour measured at $5 1 7 \mathrm { n m } ,$ and discoloration acts as an indicator of antioxidant activity (Figure 10). Antioxidant activity by the DPPH neutralisation method is often reported as $\mathrm { E C } _ { 5 0 , }$ which is defined as the efficient concentration of the antioxidant necessary to reduce the initial DPPH concentration by $5 0 \%$ . In addition, TEC50 may be used, which is the neces‐ sary time to reach the equilibrium state with $\mathrm { E C } 5 0$ [92].

![](images/38d5a5fa527b705f30829abd22da38b38a49c4afa59065b952cfddbe90b58554.jpg)  
Figure 10. DPPH scavenging mechanisms by an antioxidant (AH).

The DPPH test is a simple technique and requires only a Vis spectrophotometer or an electronic paramagnetic resonance (EPR) spectrometer. However, DPPH• is not a nat‐ ural radical but the mechanism of reaction with antioxidants is similar to that with peroxyl radicals ROO• [93].

 Analytical protocols involving DPPH radical are varied. Drawing up an analytical protocol seems to be a simple procedure. The radical is freely soluble in methanol or ethanol, solvents that also dissolve most of the antioxidants which are of technologi‐ cal or functional interest. However, many other factors, such as the reaction period (fixed time or kinetic study), temperature (room or high temperature), and result ex‐ pression are among the analytical variables that are extensively studied. Numerous reviews and research articles mention analytical details, protocol variations and in‐ novations like changing the reaction monitoring from 515 to $5 8 0 \mathrm { n m }$ in order to min‐ imise interferences due to carotenoids [94], separation from radicals of the com‐ pounds tested in order to avoid spectral overlap by means of HPLC‐PDA detectors [95] or HPLC postcolumn configuration that allows the estimation of the total anti‐ oxidant activity of the individual compounds in a mixture [96,97]. To evaluate the activity of radical elimination for compounds or extracts, the protocol proposed by Brand‐Williams et al. (1995) remains the point of reference [9].   
 Test users may be divided into two major groups: those who apply the test as a sim‐ ple, quick, adequate test for the comparative evaluation of compounds or extracts, and those interested in the mechanistic aspects/the structure–activity relations of the antioxidants or a significant evaluation of the activity of an extract.

An alternative proposal was made by Cheng et al. (2006) for the measurement of the area below the decomposition curve of DPPH $\bullet$ (AUC) [98], an approach already used for other antioxidant activity tests, like the absorption capacity of the oxygen radicals (ORAC) [8]. In this manner, the kinetic and thermodynamic properties of the reaction were considered, and the results were expressed in relation to the AUC of a reference product. Test adjustments were proposed by various authors in an attempt to minimise issues related to test sensitivity and to simplify and automate the method [96]. Musa et al. (2013) investigated the use of the DPPH dry agent as an alternative to the freshly prepared DPPH in an automated test based on microplates. The modified method was validated by means of the classic DPPH test and, according to the authors, showed excellent sensitivity, being simpler to operate and more convenient with a minimum necessary amount of solvent [99].  The neutralisation of the DPPH radical may be monitored by amperometric detec‐ tion. When voltage is applied, the DPPH radical generates a constant electrical cur‐ rent, and the decrease in the radical amount as a result of neutralisation by the anti‐ oxidants results in a decrease in the amperometric signal. Thus, antioxidant quanti‐ fication is performed by the amperometric detection of the residual concentration of unreacted DPPH radical. Sireerat and Schulte (2012) measured the antioxidant activ‐ ity of tea infusions, fruit juices and vegetable extracts by means of an automated am‐ perometric DPPH test, in which the measurements of antioxidant capacity were per‐ formed using the DPPH radical as a redox amperometric indicator. A Pb pencil was used as a working electrode, the counter‐electrode was the platinum electrode, and the reference electrode was the $\mathrm { A g / A g C l }$ electrode. This method was validated by synthetic antioxidants with known concentrations [100]. The DPPH method was used to evaluate the antioxidant capacity of phenolic com‐ pounds [101], while Sun‐Kun Yim et al. devised a continuous spectrophotometric test for reducing DPPH by NADPH (reduced form of Nicotinamide adenine dinucleotide phosphate)‐cytochrome P450 reductase (CPR) in a mixed ethanol–water solution [102].

The reaction of uric acid with DPPH incorporated in micelles was explained by E. Abuin et al. [103], while D. Bandoniene and his colleagues [104] detected the compounds’ activity of radical elimination in a mixed ethanol–water solution by means of the DPPH and HPLC–DPPH method. To study the oxidation kinetics of aminoacids, G. Ionita et al. used a water‐soluble DPPH derivative [105].

There were also reports of electrochemical methods for the measurement of antioxi‐ dant activity which are based on biosensors using cyclic voltammetry as a detection tech‐ nique [106] to measure the antioxidant capacity of tert‐butyl‐hydroxyanisole [107]. These were used to study the efficiency of some antioxidants with a low molecular weight.

Another method of determining antioxidant activity based on the amperometric re‐ duction of DPPH at the glassy carbon electrode was described by S. Milardović et al. [108]. The method was applied to the evaluation of the antioxidant activity of certain pure com‐ pounds, soluble in water or ethanol, certain antioxidants, and some samples of tea, wine and other beverages. The good correlation of measurements $\mathrm { R } ^ { 2 } = 0 . 9 9 9 3$ ), expressed as trolox equivalent, was obtained by the amperometric method proposed and the classic spectroscopic method.

Of late, the DPPH test has been re‐evaluated by Xie and Schaich (2014) for use in determining antioxidant activity by kinetic and stoichiometric approaches. The authors questioned the application of the DPPH test to classify antioxidants, and suggested it was possible to use it to distinguish the reaction mechanism of an antioxidant, i.e., SET and HAT, which display different reaction rates and models in various solvents [109].

Masek et al. (2016) researched the antioxidant activity of compounds of vegetable origin from the class of hydroxycynamic acids, by means of electrochemical methods, and the ABTS and DPPH tests [110]. The potential of these natural compounds to reduce iron and copper ions was measured by spectrophotometric analysis based on the FRAP and CUPRAC methods. Both methods, viz. electrochemical and spectrophotometric, allowed the qualitative analysis of phytochemical samples.

El Moussaoui et al. (2019) evaluated the antibacterial, antifungal and antioxidant ac‐ tivity in the root and leaves of the Withania frutescence species. The polyphenolic content was determined by the Folin–Ciocalteu reaction, and the measurement of the antioxidant activity was performed by four methods: the DPPH test, the FRAP test, total antioxidant capacity, and the $\beta$ ‐carotene discolouration test [111].

The DPPH test is commonly applied to assess the antioxidant activity of plant ex‐ tracts. To test the possible borate interference on the DPPH test, X. Chen et al. (2020) stud‐ ied the effects of borates $\mathrm { 0 { - } 1 6 ~ m M }$ sodium tetraborate) on the radical neutralisation ca‐ pacity of Gallic acid (GA, at 10, 20 and $4 0 \mathrm { m g / L }$ ). The borate presence led to a significant decrease in DPPH inhibition by the GA, and its DPPH radical neutralisation capacity may be diminished according to the borate content. This interference was interpreted as result‐ ing from GA auto‐oxidation, as well as the formation of the ester complex GA–borate at alkaline pH (\~9.50). Natural extracts of polyphenol from apple peels, parsley leaves, and green lettuce (as examples of potentially high borate content) also showed a low neutral‐ isation capacity of the DPPH radical when enriched with borate. To avoid this drawback, a proposal was made to use the acetate tampon of $\mathrm { p H } 5 . 5 0$ in preparing the samples. This paper highlighted the possible underestimation of the antioxidant properties of polyphe‐ nol extracts mainly derived from plants pre‐treated with enriched boron or borate through the DPPH test [112].

# Advantages of The DPPH Method

The application of this test allows the comprehension of the various chemical phe‐ nomena and has obvious advantages, like low cost, ease of performing experiments, re‐ producibility, applicability at room temperature, as well as automation possibilities. It ex‐ plains why the scientific community still applies the DPPH• test and is working on opti‐ mising/standardising protocols to produce significant and comparable results.

# 5. Conclusions and Future Trends

Antioxidants are becoming ever more interesting to scientists in the food field and medical professionals due to their protective roles in food products against oxidative de‐ terioration and in the body against oxidative stress‐mediated pathological processes. The efficient research of the sources of natural antioxidants and designing new antioxidant compounds require reliable methods of antioxidant activity evaluation.

Conventional methods for the measurement of antioxidant activity are still needed and specific methodological protocols are complex and require a long testing time. One of the important selection parameters of the antioxidant test is the working pH. There are tests operating in acidic (FRAP), neutral (CUPRAC) or alkaline (Folin−Ciocalteu) condi‐ tions.

Additionally, the applicability of the antioxidant test to both hydrophilic and lipo‐ philic antioxidants is an important factor. While the ABTS and CUPRAC tests can measure both hydrophilic, and lipophilic antioxidants, some methods only measure hydrophilic antioxidants (FRAP and Folin−Ciocalteu), and others only apply to hydrophobic systems (DPPH).

At the same time, the background colour in the food matrix may trigger absorbance modifications, which have more significant adverse effects in the case of discolouration reactions (ABTS, DPPH), as compared to colour‐formation reactions (FRAP, CUPRAC) [9].

Consequently, there is enormous potential in this research area, for the purpose of developing novel analytical methods of determining the compounds’ antioxidant capac‐ ity, especially in food products. For example, the development of electrochemical biosen‐ sors and the use of these in antioxidant research could be of great interest and could help in the study of the process kinetics. The great number of elements used in biological recog‐ nition, such as enzymes, aptamers, DNA/RNA and entire cells are the key elements in developing electrochemical biosensors applicable in the study of antioxidants. The ad‐ vantages of biosensors in the study of antioxidants from complex samples are the porta‐ bility, the fast measurement and the use of a small sample amount.

Author Contributions: Conceptualisation, C.A. and I.G.M.; methodology, C.A.; Writing—Original draft preparation, I.G.M.; Writing—Review and editing, C.A.; supervision, C.A. All authors have read and agreed to the published version of the manuscript.

Funding: This work was supported by a grant of the Romanian Ministry of Education and Research, CNCS—UEFISCDI, project number PN‐III‐P4‐ID‐PCE‐2020‐0923, within PNCDI III.

Institutional Review Board Statement: Ethical review and approval were waived for this study, due to the character of the publication based on reviewing the recent literature.

Informed Consent Statement: Not applicable.

Conflicts of Interest: The authors declare no conflict of interest.

# References

1. Rodrigo, R. „Oxidative stress and antioxidants: their role in human diseases”, in: Nova Biomedical Books, 2009, 9‐10.   
2. Shahidi, F., Zhong, Y., „Measurement of antioxidant activity”, in: J. Funct. Foods, 2015, 18, 757‐781.   
3. Moharram, H.A.,Youssef, M.M., „Methods for Determining the Antioxidant Activity: A Review”, in: Alexandria Int. J. Food Sci. and Technol., 2014, 11, 31‐42.   
4. Shahidi, F., & Zhong, Y., ”Revisiting the polar paradox theory: A critical overview”, in: J. Agric. Food Chem., 2011, 59, 3499–3504.   
5. Antolovich, M., Prenzler, P. D., Patsalides, E., McDonald, S., Robards, K., Methods for testing antioxidant activity, in: The Ana‐ lyst, 2002, 127, 183–198.   
6. Carocho, M., Ferreira, C.F.R., „A reviews on antioxidants, proxidants and related controversy. Natural and synthetic com‐ pounds, screening and analysis methodologies and future perspectives”, in: Food Chem. Toxicol., 2013, 51, 15‐25.   
7. Dalton, T. P., Shertzer, H. G., & Puga, A.„ Regulation of gene expression by reactive oxygen”, in: Annu. Rev. Pharmacol. Toxicol., 1999, 39, 67–101.   
8. Prior, R.L., Wu, X., Schaich, K., „Standardized methods for the determination of antioxidant capacity and phenolics in foods and dietary supplements”, in: J. Agric. Food Chem., 2005, 53, 4290–4302.   
9. Apak, R., Çapanoğlu, E., Shahidi, F., „Measurement of antioxidant activity and capacity ‐ recent trends and applications”, in: Alexandria Int. J. Food Sci. and Technol., 2018, 1‐283.   
10. Çekiç, S. D., Çetinkaya, A., Avan, A.N., Apak, R., „Correlation of total antioxidant capacity with reactive oxygen species (ROS) consumption measured by oxidative conversion” in: J. Agric. Food Chem., 2013, 61, 5260–5270.   
11. Becker, E. M., Nissen, L. R., & Skibsted, L. H., „Antioxidant evaluation protocols. Food quality or health effects”, in: Eur. Food Res. and Technol., 2004, 219, 561–571.   
12. Huang. D., Boxin, O.U., Prior, P.L., „The chemistry behind antioxidant capacity assays”, in: J. Agric. Food Chem., 2005, 55, 1841‐ 1856.   
13. Apak, R., Gorinstein, S., Böhm, V., Schaich, K. M., Özyürek, M., & Güçlü, K., „Methods of measurement and evaluation of natural antioxidant capacity/activity”, in: Pure Appl. Chem., 2013, 8,997–998.   
14. Godoy‐Navajas, J., Aguilar‐Caballos, M. P., Gomez‐Hens, A., „Long‐wavelength fluorimetric determination of food antioxidant capacity using Nile blue as reagent”, in: J. Agric. Food Chem., 2011, 59, 2235–2240.   
15. Guclu, K., Kibrislioglu, G., Ozyurek, M., & Apak, R., „Development of a fluorescent probe for measurement of peroxyl radical scavenging activity in biological samples”, in: J. Agric. Food Chem., 2014, 62, 1839–1845.   
16. Nkhili, E., Brat, P., „Reexamination of the ORAC assay: Effect of metal ions”, in: Anal. Bioanal. Chem., 2011, 400, 1451–1458.   
17. Ciz, M., Cizova, H., Denev, P., Kratchanova, M., Slavov, A., Lojek, A., „Different methods for control and comparison of the antioxidant properties of vegetables”, in: Food Control, 2010, 21, 518‐523.   
18. Apak, R., Özyürek, M., Güçlü, K., Çapanoğlu, E., „Antioxidant activity/capacity measurement. 2. Hydrogen atom transfer (HAT)‐based, mixed‐mode (electron transfer (ET)/HAT), and lipid peroxidation assays”, in: J. Agric. Food Chem., 2016, 64, 1028– 1045.   
19. Lissi, E., Salimhanna, M., Pascual, C., Delcastillo, M.D., „Evaluation of total antioxidant potential (TRAP) and total antioxidant reactivity from luminol‐enhanced chemiluminescence measurements”, in: Free Radic. Biol. Med., 1995, 18, 153–158.   
20. Regoli, F., Winston, G.W., „Quantification of total oxidant scavenging capacity of antioxidants for peroxynitrite, peroxyl radi‐ cals, and hydroxyl radicals”, in: Toxicol Appl. Pharmacol., 1999, 156, 96–105.   
21. Wright, J.S., Johnson, E.R., Di Labio, G.A., „Predicting the activity of phenolic antioxidants: theoretical method, analysis of substituent effects, and application to major families of antioxidants”, in: J. Am. Chem. Soc., 2001, 123, 1173–1183.   
22. Apak, R., Özyürek, M., Güçlü, K., Çapanoğlu, E., „Antioxidant activity/capacity measurement. 1. Classification, physicochem‐ ical principles, mechanisms, and electron transfer (ET)‐based assays”, in: J. Agric. Food Chem., 2016, 64, 997–1045.   
23. Apak, R., Güçlü, K., Özyürek, M. & Karademir, S.E., „Novel total antioxidant capacity index for dietary polyphenols and vita‐ mins C and E, using their cupric ion reducing capability in the presence of neocuproine: CUPRAC method”, in: J. Agric. Food Chem., 2004, 52, 7970–7981.   
24. Apak, R., Güçlü, K., Özyürek, M., & Celik, S.E., „Mechanism of antioxidant capacity assays and the CUPRAC (cupric ion re‐ ducing antioxidant capacity) assay”, in: Microchim. Acta, 2008, 160, 413–419.   
25. Bener, M., Özyürek, M., Güçlü, K. & Apak, R.A., „Development of a low‐cost optical sensor for cupric reducing antioxidant capacity measurement of food extracts”, in: Anal. Chem., 2010, 82, 4252–4258.   
26. Rice‐Evans, C.A., Miller, N.J., Paganga, G., „Structure–antioxidant activity relationships of flavonoids and phenolic acids”, in: Free Radic. Biol. Med., 1996, 20, 933–956.   
27. Campos, C., Guzmán, R., López‐Fernández, E. & Casado, Á., „Evaluation of the copper (II) reduction assay using bathocu‐ proinedisulfonic acid disodium salt for the total antioxidant capacity assessment: the CUPRAC‐BCS assay”, in: Anal. Biochem., 2009, 392, 37–44.   
28. Smith, P., Krohn, R.I., Hermanson, G. et al., „Measurement of protein using bicinchoninic acid”, in: Anal. Biochem., 1985, 150, 76–85.   
29. Çelik, S.E., Özyürek, M. Güçlü, K., Apak, R., „Differences in responsivity of original cupric reducing antioxidant capacity and cupric‐bathocuproine sulfonate assays to antioxidant compounds”, in: Anal. Biochem., 2012, 423, 36–38.   
30. Zhou, F., & Millhauser, G.L., „The rich electrochemistry and redox reactions of the copper sites in the cellular prion protein”, in: Coord. Chem. Rev. 2012, 256, 2285–2296.   
31. Marques, S.S., Magalhães, L.M., Tóth, I.V., & Segundo, M.A., „Insights on antioxidant assays for biological samples based on the reduction of copper complexes–the importance of analytical conditions”, in: Int. J. Mol. Sci. 2014, 15, 11387–11402.   
32. Ozyürek, M., Bektasogglu, B., Güçlü, K., Güngör, N., & Apak, R., „Simultaneous total antioxidant capacity assay of lipophilic and hydrophilic antioxidants in the same acetone– water solution containing $2 \%$ methyl‐b‐cyclodextrin using the cupric reduc‐ ing antioxidant capacity (CUPRAC) method”, in: Anal. Chim. Acta, 2008, 630, 28–39.   
33. Tufan, A. N., Celik, S. E., Ozyürek, M., Güçlü, K., Apak, R., „Direct measurement of total antioxidant capacity of cereals: QUENCHER‐CUPRAC method”, in: Talanta, 2013, 108, 136–142.   
34. Bener, M., Ozyürek, M., Güçlü, K., Apak, R., „Novel optical fiber reflectometric CUPRAC sensor for total antioxidant capacity measurement of food extracts and biological samples”, in: J. Agric. Food Chem., 2013, 61, 8381– 8388.   
35. Özyürek, M., Güçlü, K., Apak, R., „The main and modified CUPRAC methods of antioxidant measurement”, in: Trends in Anal. Chem., 2011, 30, 652–664.   
36. Christodouleas, D.C., Fotakis, C., Papadopoulos, K., Calokerinos, A.C., „Evaluation of total reducing power of edible oils”, in: Talanta, 2014, 130, 233–240.   
37. Ribeiro, J.P., Magalhaes, L.M., Reis, S., Lima, J.L., Segundo, M.A., „High‐throughput total cupric ion reducing antioxidant ca‐ pacity of biological samples determined using flow injection analysis and microplate–based methods”, in: Anal. Sci., 2011, 27, 483.   
38. Gorinstein, S., Leontowicz, M., Leontowicz, H. et al., „Supplementation of garlic lowers lipids and increases antioxidant capac‐ ity in plasma of rats”, in: Nutr. Res., 2006, 26, 362–368.   
39. Bean, H., Radu, F., De, E., Schuler, C., Leggett, R.E. & Levin, R.M., „Comparative evaluation of antioxidant reactivity within obstructed and control rabbit urinary bladder tissue using FRAP and CUPRAC assays”, in: Mol. and Cell. Biochem., 2009, 323, 139–142.   
40. Hegerman, A. E., Riedl, K. M., Jones, G., Sovik, K. N., Rechard, N. T., Hartzfeld, P. W., Reichel, T. L., „High molecular weight plant polyphenolics (tannins) as biological antioxidants”, in: J. Agric. Food Chem., 1998, 46, 1887–1892.   
41. Molina‐Diaz, A., Ortega‐Carmona, I., Pascual‐Reguera, M. I., „Indirect spectrophotometric determination of ascorbic acid with ferrozine by flow‐injection analysis”, in: Talanta, 1998, 47, 531– 536.   
42. Berker, K. I., Gueclue, K., Tor, I., Demirata, B., & Apak, R., „Total antioxidant capacity assay using optimized ferricyanide/Prus‐ sian blue method”, in: Food Anal. Methods, 2010, 3, 154–168.   
43. Berker, K. I., Demirata, B., & Apak, R., „Determination of total antioxidant capacity of lipophilic and hydrophilic antioxidants in the same solution by using ferric‐ferricyanide assay”, in: Food Anal. Methods, 2012, 5, 1150–1158.   
44. Pulido, R., Bravo, L., Saura‐Calixto, F., „Antioxidant activity of dietary polyphenols as determined by a modified ferric reducing antioxidant power assay”, in: J. Agric. Food Chem., 2000, 48, 3396–3402.   
45. Ziyatdinova, G., Nizamova, A., Budnikov, H., „Novel coulometric approach to evaluation of total free polyphenols in tea and coffee beverages in presence of milk proteins”, in: Food Anal. Methods, 2011, 4, 334–340.   
46. Ziyatdinova, G., Salikhova, I., Budnikov, H., „Coulometric titration with electrogenerated oxidants as a tool for evaluation of cognac and brandy antioxidant properties”, in: Food Chem., 2014, 150, 80–86.   
47. Brainina, K. Z., Varzakova, D. P., Gerasimova, E. L., „A chronoamperometric method for determining total antioxidant activity”, in: J. Anal. Chem., 2012, 67, 364–369.   
48. Benzie, I.F.F., „Evolution of dietary antioxidants”, in: Comp. Biochem. & Physiol. A, 2003, 136, 113–126.   
49. Benzie, I.F.F. & Strain, J.J., „Ferric reducing (antioxidant) power as a measure of antioxidant capacity, the FRAP assay and its modification for measurement of ascorbic acid (FRASC)”, in: Meth. Enzymol., 1999, 299, 15–27.   
50. Chung, W.Y., Chung, J.K.O., Szeto, Y.T., Tomlinson, B. & Benzie, I.F.F., „Plasma ascorbic acid, measurement. Stability and clin‐ ical utility revisited, in: Clin. Biochemi., 2001, 34, 623–627.   
51. García‐Alonso, J., Ros, G., Vidal‐Guevara, M.L., Peragio, M.J., „Acute intake of phenolic‐rich juice improves antioxidant status in healthy subjects”, in: Nutr. Res., 2006, 26, 330–339.   
52. Bartosz, G., „Non‐enzymatic antioxidant capacity assay, limitations of use in biomedicine”, in: Free Radic. Res., 2010, 44, 711– 720.   
53. Pastor, F.T., Šegan, D.M., Gorjanović, S.Ž., Kalušević, A.M., Sužnjević, D.Ž., „Development of voltammetric methods for anti‐ oxidant activity determination based on Fe (III) reduction”, in: Microchem. J., 2020, 155, 1‐6.   
54. Singleton, V. L., Orthofer, R., Lamuela‐Raventos, R. M., „Analysis of total phenols and other oxidation substrates and antioxi‐ dants by means of Folin–Ciocalteu reagent”, in: Meth. Enzymol., 1999, 299, 152–178.   
55. Blainski, A., Lopes, G.C., Mello, de J.C.P., „Application and analysis of the Folin Ciocalteu method for the determination of the total phenolic content from limonium brasiliense”, in: Molecules, 2013, 18, 6852–6865.   
56. Magalhaes, L. M., Segundo, M. A., Reis, S., & Lima, J. L. F. C., „Methodological aspects about in vitro evaluation of antioxidant properties”, in: Anal. Chim. Acta, 2008, 613, 1–19.   
57. Barrows, J. N., Jameson, G. B., Pope, M. T., „Structure of a heteropoly blue. The four‐electron reduced $\beta$ ‐12‐molybdophosphate anion”, in: J. Am. Chem. Soc. 1985, 107, 1771‐1773.   
58. Karadag, A., Ozcelik, B., Saner, S., „Review of methods to determine antioxidant capacities”, in: Food Anal. Methods, 2009, 2, 41– 60.   
59. Blasco, A. J., Rogerio, M. C., Gonzalez, M. C., Escarpa, A., „Electrochemical index as a screening method to determine total polyphenolics in foods: A proposal”, in: Anal. Chim. Acta, 2005, 539, 237–244.   
60. Vallverdú‐Queralt, A., Medina‐Remón, A., Martinez‐Huelamo, M. et al., „Phenolic profile and hydrophilic antioxidant capacity as chemotaxonomic markers of tomato varieties”, in: J. Agric. Food Chem., 2011, 59, 3994–4001.   
61. Medina‐Remón, A., Barrionuevo‐González, A., Zamora‐Ros, R. et al., „Rapid Folin–Ciocalteu method using microtiter 96‐well plate cartridges for solid phase extraction to assess urinary total phenolic compounds, as a biomarker of total polyphenols intake”, in: Anal. Chim. Acta, 2009, 634, 54–60.   
62. Medina‐Remón, A., Tresserra‐Rimbau, A., Pons, A. et al., „Effects of total dietary polyphenols on plasma nitric oxide and blood pressure in a high cardiovascular risk cohort. The PREDIMED randomized trial”, in: Nutr. Metab. Cardiovas., 2015, 25, 60–67.   
63. Guo, X., Tresserra‐Rimbau, A., Estruch, R. et. al., „Effects of polyphenol, measured by a biomarker of total polyphenols in urine, on cardiovascular risk factors after a long‐term follow‐up in the PREDIMED Study”, in: Oxid. Med. Cell. Longev., 2016, 1–11.   
64. Pedret, A., Valls, R., Fernandez‐Castilljo, S. et al., „Polyphenol‐rich foods exhibit DNA antioxidative properties and protect the glutathione system in healthy subjects”, in: Mol. Nutr. Food Res., 2012, 56, 1025–1033.   
65. Alcalde, B., Granados, M., Saurina, J., „Exploring the Antioxidant Features of Polyphenols by Spectroscopic and Electrochemical Methods”, in: Antioxidants 2019, 8, 1‐10.   
66. Siddeeg, A., AlKehayez, N. M., Abu‐Hiamed, H. A., Al‐Sanea, E. A., AL‐Farga, A. M. „Mode of action and determination of antioxidant activity in the dietary sources: An overview”, Saudi J. Biol. Sci., 2021, 28, 1633–1644.   
67. Miller, N. J., Diplock, A. T., Rice‐Evans, C., Davies, M. J., Gopinathan, V., Milner, A., $, , \mathrm { A }$ novel method for measuring antioxidant capacity and its application to monitoring the antioxidant status in premature neonates”, in: Clin. Sci. 1993, 84, 407–412.   
68. Durmaz, G., „Freeze‐dried ABTS $^ +$ method: A ready‐to‐use radical powder to assess antioxidant capacity of vegetable oils”, in: Food Chem., 2012, 133, 1658–1663.   
69. Shin, T., Murao, S. & Matsumura, E., „A chromogenic oxidative coupling reaction of laccase. Applications for laccase and angi‐ otensin I converting enzyme assay”, in: Anal. Biochem., 1987, 166, 380–388.   
70. Solís‐Oba, M., Ugalde‐Saldívar, V.M., González, I. & Viniegra‐González, G., „An electrochemical– spectrophotometrical study of the oxidized forms of the mediator 2,2′‐azino‐bis‐(3‐ethylbenzothiazoline‐6‐ sulfonic acid) produced by immobilized laccase”, in: J. Electroanal. Chem., 2005, 579, 59–66.   
71. Arnao, M.B., Casas, J.L., Río, J.A., Acosta, M. & García‐Cánovas, F., „An enzymatic colorimetric method for measuring naringin using 2,2′‐azino‐bis‐(3‐ethylbenzthiazoline‐6‐sulfonic acid) (ABTS) in the presence of peroxidase”, in: Anal. Biochem., 1990, 185, 335–338.   
72. Gong, Y., Plander, S., Xu, H., Simandi, B., Gao, Y., „Supercritical CO2 extraction of oleoresin from marigold (Tagetes erecta L.) flowers and determination of its antioxidant components with online HPLC‐ABTS+ assay”, in: J. Sci. Food Agric., 2011, 91, 2875– 2881.   
73. Chan‐Eam, S., Teerasong, S., Damwan, K., Nacapricha, D., Chaisuksant, R., „Sequential injection analysis with electrochemical detection as a tool for economic and rapid evaluation of total antioxidant capacity”, in: Talanta, 2011, 84, 1350– 1354.   
74. Cerretani, L., Giuliani, A., Maggio, R. M., Bendini, A., Gallina Toschi, T., Cichelli, A., „Rapid FTIR determination of water, phenolics and antioxidant activity of olive oil”, in: Eur. J. Lipid Sci.Technol., 2010, 112, 1150–1157.   
75. Milardovic, S., Kerekovic, I., Rumenjak, V., $, , \mathrm { A }$ flow injection biamperometric method for determination of total antioxidant capacity of alcoholic beverages using bienzymatically produced ABTS”, in: Food Chem., 2007, 105, 1688– 1694.   
76. Miller, N.J., Sampson, J., Candeias, L.P., Bramley, P.M., Rice‐Evans, C.A., „Antioxidant activities of carotenes and xantho‐ phylls”, in: FEBS Letters, 1996, 384, 240–242.   
77. Böhm, V., Puspitasari‐Nienaber, N.L., Ferruzzi, M.G. & Schwartz, S.J., „Trolox equivalent antioxidant”, in: J. Agric. Food Chem. 2002, 50, 221–226.   
79. Dec, J., Bollag, J.M., „Detoxification of substituted phenols by oxidoreductive enzymes through polymerization reactions”, in: Arch. Environ. Contam. Toxicol., 1990, 19, 543–550.   
80. Cano, A., Acosta, M. & Arnao, M.B., $, , \mathrm { A }$ method to measure antioxidant activity in organic media. Application to lipophilic vitamins”, in: Redox Rep., 2000, 5, 365–370.   
81. Puangbanlang, C., Sirivibulkovit, K., Nacapricha, D., Sameenoi, Y., $, , \mathrm { A }$ paper‐based device for simultaneous determination of antioxidant activity and total phenolic content in food samples”, in: Talanta 2019, 198, 542‐549.   
82. Walker, R.B. & Everette, J.D., „Comparative reaction rates of various antioxidants with ABTS radical cation”, in: J. Agric. Food Chem., 2009, 57, 1156–1161.   
83. Zheng, L., Zhao, M., Xiao, C., Zhao, Q., Su, G. „Practical problems when using ABTS assay to assess the radical‐scavenging activity of peptides. Importance of controlling reaction pH and time”, in: Food Chem., 2016, 192, 288–294.   
84. Lemańska, K., Szymusiak, H., Tyrakowska, B., Zieliński, R., Soffers, A.E., Rietjens, I.M., „The influence of pH on antioxidant properties and the mechanism of antioxidant action of hydroxyflavones”, in: Free Radic. Biol. Med., 2001, 31, 869–881.   
85. Cano, A., Alcaraz, O., Acosta, M. & Arnao, M.B., „On‐line antioxidant activity determination. Comparison of hydrophilic and lipophilic antioxidant activity using the ABTS•+ assay”, in: Redox Rep., 2002, 7, 103–109.   
86. Schlesier, K., Harwat, M., Böhm, V., & Bitsch, R., „Assessment of antioxidant activity by using different in vitro methods”, in: Free Radic. Res., 2002, 36, 177–187.   
87. Strube, M., Haenen, G.R.M.M., Van den Berg, H., Bast, A., „Pitfalls in a method for assessment of total antioxidant capacity”, in: Free Radic. Res., 1997, 26, 515–521.   
88. Schaich, Tian, K.M.X. & Xie, J. „Hurdles and pitfalls in measuring antioxidant efficacy. A critical evaluation of ABTS, DPPH, and ORAC assays”, in: J. Funct Foods, 2015, 14, 111–125.   
89. Tian, X., Schaich, K.M., „Effects of molecular structure on kinetics and dynamics of the Trolox Equivalent Antioxidant Capacity assay with ABTS•+”, in: J. Agric. Food Chem., 2013, 61, 5511–5519.   
90. Williams, D. E., „Structure of 2,2‐diphenyl‐1‐picrylhydrazyl free radical”, in: J. Am. Chem. Soc., 1966, 88, 5665–5666.   
91. Staško, A., Brezová, V., Biskupič, S., Mišík, V., „The potential pitfalls of using 1,1‐diphenyl‐2‐picrylhydrazyl to characterize antioxidants in mixed water solvents”, in: Free Radic. Res., 2007, 41, 379–390.   
92. Foti, M.C., „Use and Abuse of the DPPH• Radical”, in: J. Agric. Food Chem, 2015, 63, 8765‐8776.   
93. Benzie, I. F. F., Strain, J. J., „Ferric reducing/antioxidant power assay: Direct measure of total antioxidant activity of biological fluids and modified version for simultaneous measurement of total antioxidant power and ascorbic acid concentration”, in: Meth. Enzymol., 1999, 299, 15–27.   
94. Jiménez‐Escrig, A., Jiménez‐Jiménez, I., Sánchez‐Moreno, C., Saura‐Calixto, F., „Evaluation of free radical scavenging of dietary carotenoids by the stable radical 2,2‐diphenyl‐1‐picrylhydrazyl”, in: J. Sci. Food Agric., 2000, 80, 1686–1690.   
95. Yamaguchi, T., Takamura, H., Matoba, T., Terao, J., „HPLC method for evaluation of the free radical scavenging activity of foods by using 1,1‐diphenyl‐2‐picrylhydrazyl”, in: Biosci. Biotechnol. Biochem., 1998, 62, 1201–1204.   
96. Kedare, S.B. & Singh, R.P., „Genesis and development of DPPH method of antioxidant assay”, in: J. Food Sci. Technol., 2011, 48, 412–422.   
97. Mishra, K., Ojha, H., Chaudhury, N.K., „Estimation of antiradical properties of antioxidants using DPPH assay. A critical review and results”, in: Food Chem., 2012, 130, 1036–1043.   
98. Cheng, Z., Moore, J., Yu, L., „High‐throughput relative DPPH radical scavenging capacity assay”, in: J. Agric. Food Chem., 2006, 54, 7429–7436.   
99. Musa, K. H., Abdullah, A., Kuswandi, B., Hidayat, M. A., „A novel high throughput method based on the DPPH dry reagent array for determination of antioxidant activity”, in: Food Chem., 2013, 141, 4102–4106.   
100. Sireerat, I., Schulte, A., „Automated electrochemical free radical scavenger screening in dietary samples”, in: Anal. Chem., 2012, 84, 6767–6774.   
101. Sanchez‐Moreno, C., Larrauri, J.A., Saura‐Calixto, F., „New parameter for evaluation of free radical scavenging capacity of polyphenols”, in: 2nd International Electronic Conference on Synthetic Organic Chemistry, 1998, 1–30.   
102. Sung‐Kun, Y., Su‐Jung, Y., Chul‐Ho, Y., „A continuous spectrophotometric assay for NADPH‐cytochrome P450 reductase ac‐ tivity using 1,1‐diphenyl‐2‐picrylhydrazyl”, in: Int. J. Biochem. Mol. Biol. 2004, 37, 629–633.   
103. Abuin, E., Lissi, E., Ortiz, P., Henriquez, C., „Uric acid reaction with DPPH radicals at the micellar interface”, in: Bol. Soc. Chil. Quim. 2002, 47, 145– 149.   
104. Bandoniene, D., Murkovic, M., Pfannhauser, W., Venskutonis, P.R., Gruzdiene, D., „Detection and activity evaluation of radical scavenging compounds by using DPPH free radical and on‐line HPLC– DPPH methods”, in: Eur. Food Res. Technol. 2002, 214, 143–147.   
105. Ionita, G., Sahini, V. Em., Semenescu, G., Ionita, P., „Kinetics oxidation of amino acids by some free stable hydrazyl radicals”, in: Acta Chim. Slov. 2000, 47, 111– 119.   
106. Ruiz, M.A., Reviejo, A.J., Parrado, C., Pingarron, J.M., „Development of an amperometric enzyme biosensor for the determina‐ tion of the antioxidant tert‐butylhydroxyanisole in a medium of reversed micelles”, in: Electroanalysis 1996, 8, 529–533.   
107. Chevion, S., Berry, E.M., Kitrossky, N.K., Kohen, N., „Evaluation of plasma low molecular weight antioxidant capacity by cyclic voltammetry”, in: Free Radic. Biol. Med., 1997, 22, 411–421.   
108. Milardović, S., Ivekovic, D., Grabarić, B.S., „A novel amperometric method for antioxidant activity determination using DPPH free radical”, in: Bioelectrochemistry 2006, 68, 175–180.   
109. Xie, J., Schaich, K. M., „Re‐evaluation of the 2,2‐diphenyl‐ 1‐picrylhydrazyl free radical (DPPH) assay for antioxidant activity”, in: J. Agric. Food Chem., 2014, 62, 4251– 4260.   
110. Masek, A., Chrzescijanska, E., Latos, M., Zaborski, M., „Antioxidant Potential of Hydroxycinnamic Acids in Advanced Oxida‐ tion Processes”, in: Int. J. Electrochem. Sci. 2016, 11, 8849‐8856.   
111. El Moussaoui, A., Jawhari, F. Z., Almehdi, A. M., Elmsellem, H., Benbrahim, K. F., Bousta, D., Bari, A., „Antibacterial, antifungal and antioxidant activity of total polyphenols of Withania frutescens.L”, in: Bioorg. Chem. 2019, 93, 1‐9.   
112. Chena, X., Lianga, L., Hanc, C., „Borate suppresses the scavenging activity of gallic acid and plant polyphenol extracts on DPPH radical: A potential interference to DPPH assay”, in: LWT‐Food Sci. Technol. 2020, 131, 3‐16